/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref.statistical;

import edu.stanford.nlp.coref.CorefAlgorithm;
import edu.stanford.nlp.coref.CorefProperties;
import edu.stanford.nlp.coref.CorefUtils;
import edu.stanford.nlp.coref.data.Dictionaries;
import edu.stanford.nlp.coref.data.Document;
import edu.stanford.nlp.coref.statistical.Compressor;
import edu.stanford.nlp.coref.statistical.DocumentExamples;
import edu.stanford.nlp.coref.statistical.Example;
import edu.stanford.nlp.coref.statistical.FeatureExtractor;
import edu.stanford.nlp.coref.statistical.MetaFeatureExtractor;
import edu.stanford.nlp.coref.statistical.PairwiseModel;
import edu.stanford.nlp.coref.statistical.StatisticalCorefProperties;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class StatisticalCorefAlgorithm
implements CorefAlgorithm {
    private final Map<Pair<Boolean, Boolean>, Double> thresholds;
    private final FeatureExtractor extractor;
    private final PairwiseModel classifier;
    private final int maxMentionDistance;
    private final int maxMentionDistanceWithStringMatch;

    public StatisticalCorefAlgorithm(Properties props, Dictionaries dictionaries) {
        this(props, dictionaries, StatisticalCorefProperties.wordCountsPath(props), StatisticalCorefProperties.rankingModelPath(props), CorefProperties.maxMentionDistance(props), CorefProperties.maxMentionDistanceWithStringMatch(props), StatisticalCorefProperties.pairwiseScoreThresholds(props));
    }

    public StatisticalCorefAlgorithm(Properties props, Dictionaries dictionaries, String wordCountsFile, String modelFile, int maxMentionDistance, int maxMentionDistanceWithStringMatch, double threshold) {
        this(props, dictionaries, wordCountsFile, modelFile, maxMentionDistance, maxMentionDistanceWithStringMatch, new double[]{threshold, threshold, threshold, threshold});
    }

    public StatisticalCorefAlgorithm(Properties props, Dictionaries dictionaries, String wordCountsFile, String modelPath, int maxMentionDistance, int maxMentionDistanceWithStringMatch, double[] thresholds) {
        this.extractor = new FeatureExtractor(props, dictionaries, null, wordCountsFile);
        this.classifier = PairwiseModel.newBuilder("classifier", MetaFeatureExtractor.newBuilder().build()).modelPath(modelPath).build();
        this.maxMentionDistance = maxMentionDistance;
        this.maxMentionDistanceWithStringMatch = maxMentionDistanceWithStringMatch;
        this.thresholds = StatisticalCorefAlgorithm.makeThresholds(thresholds);
    }

    private static Map<Pair<Boolean, Boolean>, Double> makeThresholds(double[] thresholds) {
        HashMap<Pair<Boolean, Boolean>, Double> thresholdsMap = new HashMap<Pair<Boolean, Boolean>, Double>();
        thresholdsMap.put(new Pair<Boolean, Boolean>(true, true), thresholds[0]);
        thresholdsMap.put(new Pair<Boolean, Boolean>(true, false), thresholds[1]);
        thresholdsMap.put(new Pair<Boolean, Boolean>(false, true), thresholds[2]);
        thresholdsMap.put(new Pair<Boolean, Boolean>(false, false), thresholds[3]);
        return thresholdsMap;
    }

    @Override
    public void runCoref(Document document) {
        Compressor<String> compressor = new Compressor<String>();
        if (Thread.interrupted()) {
            throw new RuntimeInterruptedException();
        }
        HashMap<Pair<Integer, Integer>, Boolean> pairs = new HashMap<Pair<Integer, Integer>, Boolean>();
        for (Map.Entry<Integer, List<Integer>> e : CorefUtils.heuristicFilter(CorefUtils.getSortedMentions(document), this.maxMentionDistance, this.maxMentionDistanceWithStringMatch).entrySet()) {
            Iterator<Serializable> iterator = e.getValue().iterator();
            while (iterator.hasNext()) {
                int m1 = iterator.next();
                pairs.put(new Pair<Integer, Integer>(m1, e.getKey()), true);
            }
        }
        DocumentExamples examples = this.extractor.extract(0, document, pairs, compressor);
        ClassicCounter<Pair<Integer, Integer>> pairwiseScores = new ClassicCounter<Pair<Integer, Integer>>();
        for (Example mentionPair : examples.examples) {
            if (Thread.interrupted()) {
                throw new RuntimeInterruptedException();
            }
            pairwiseScores.incrementCount(new Pair<Integer, Integer>(mentionPair.mentionId1, mentionPair.mentionId2), this.classifier.predict(mentionPair, examples.mentionFeatures, compressor));
        }
        ArrayList mentionPairs = new ArrayList(pairwiseScores.keySet());
        Collections.sort(mentionPairs, (p1, p2) -> {
            double diff = pairwiseScores.getCount(p2) - pairwiseScores.getCount(p1);
            return diff == 0.0 ? 0 : (int)Math.signum(diff);
        });
        HashSet seenAnaphors = new HashSet();
        for (Pair pair : mentionPairs) {
            if (seenAnaphors.contains(pair.second)) continue;
            if (Thread.interrupted()) {
                throw new RuntimeInterruptedException();
            }
            seenAnaphors.add(pair.second);
            Dictionaries.MentionType mt1 = document.predictedMentionsByID.get(pair.first).mentionType;
            Dictionaries.MentionType mt2 = document.predictedMentionsByID.get(pair.second).mentionType;
            double d = pairwiseScores.getCount(pair);
            Pair<Boolean, Boolean> pair2 = new Pair<Boolean, Boolean>(mt1 == Dictionaries.MentionType.PRONOMINAL, mt2 == Dictionaries.MentionType.PRONOMINAL);
            if (!(d > this.thresholds.get(pair2))) continue;
            CorefUtils.mergeCoreferenceClusters(pair, document);
        }
    }
}

