/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.digimorph;

import eu.fbk.dh.tint.digimorph.DigiMorph;
import eu.fbk.utils.core.CommandLine;
import java.io.File;
import java.util.LinkedList;
import java.util.Scanner;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.slf4j.LoggerFactory;

public class Main {
    private static void printUsage(Options opt) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("echo <word> | java -jar DigiMorph.jar \n       cat <path to file> | java -jar DigiMorph.jar\n\n", opt);
        System.exit(1);
    }

    private static void retrain(File filepath, File outputPath, boolean include_lemma) {
        DigiMorph.re_train(filepath, outputPath, include_lemma);
        System.exit(0);
    }

    public static void main(String[] args) {
        String line;
        block6: {
            try {
                CommandLine cmd = CommandLine.parser().withName("run-digimorph").withHeader("Run or retrain DigiMorph tool").withOption("r", "retrain-input-file", "Input file in Morph-IT for retraining", "FILE", CommandLine.Type.FILE_EXISTING, true, false, false).withOption("w", "retrain-output-file", "Output file for retraining", "FILE", CommandLine.Type.FILE, true, false, false).withOption("l", "lemma", "Include lemma").withOption("v", "version", "Print the tool version").withLogger(LoggerFactory.getLogger((String)"eu.fbk")).parse(args);
                if (cmd.hasOption("version")) {
                    System.out.println(DigiMorph.getVersion());
                    System.exit(0);
                }
                File retrainInputFile = (File)cmd.getOptionValue("retrain-input-file", File.class);
                File retrainOutputFile = (File)cmd.getOptionValue("retrain-output-file", File.class);
                boolean lemma = cmd.hasOption("lemma");
                if (retrainInputFile == null && retrainOutputFile == null) break block6;
                if (retrainInputFile == null || retrainOutputFile == null) {
                    Main.retrain(retrainInputFile, retrainOutputFile, lemma);
                    break block6;
                }
                throw new CommandLine.Exception("Input file or output path missing for retrain");
            }
            catch (Exception e) {
                CommandLine.fail((Throwable)e);
            }
        }
        LinkedList<String> text = new LinkedList<String>();
        Scanner scanner = new Scanner(System.in);
        while (scanner.hasNextLine() && (line = scanner.nextLine()).compareToIgnoreCase("morph()") != 0) {
            text.add(line);
        }
        DigiMorph dm = new DigiMorph();
        for (String s : dm.getMorphology(text)) {
            System.out.println(s);
        }
    }
}

