/*
 * Decompiled with CFR 0.152.
 */
package jvntokenizer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import jvntokenizer.PennTokenizer;

public class JVnTokenizer {
    public static void main(String[] args) {
        if (args.length != 2) {
            JVnTokenizer.displayHelp();
            return;
        }
        try {
            String option = args[0];
            if (option.equalsIgnoreCase("-inputfile")) {
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(args[1]), "UTF-8"));
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(args[1] + ".tkn"), "UTF-8"));
                String line = "";
                while ((line = in.readLine()) != null) {
                    out.write(PennTokenizer.tokenize(line));
                    out.write("\n");
                }
                in.close();
                out.close();
            } else if (option.equalsIgnoreCase("-inputdir")) {
                System.out.println("Tokenize input");
                File inputDir = new File(args[1]);
                File[] childrent = inputDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".sent");
                    }
                });
                for (int i = 0; i < childrent.length; ++i) {
                    BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(childrent[i]), "UTF-8"));
                    BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(childrent[i] + ".tkn"), "UTF-8"));
                    String line = "";
                    while ((line = in.readLine()) != null) {
                        out.write(PennTokenizer.tokenize(line));
                        out.write("\n");
                    }
                    in.close();
                    out.close();
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error:" + e.getMessage());
        }
    }

    public static void displayHelp() {
        System.out.println("Usage:");
        System.out.println("\tCase 1: JVnTokenizer -inputfile <input data file>");
        System.out.println("\tCase 2: JVnTokenizer -inputdir <input data directory>");
        System.out.println("Where:");
        System.out.println("\t<input data file> is the file containing input text that need to");
        System.out.println("\thave sentences tokenized (each sentence on a line)");
        System.out.println("\t<input data directory> is the directory containing multiple input .sent files");
        System.out.println();
    }
}

