/*
 * Decompiled with CFR 0.152.
 */
package jvntextpro.service;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;

public class TaggingClient {
    String host;
    int port;
    private BufferedReader in;
    private BufferedWriter out;
    private Socket sock;

    public TaggingClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public boolean connect() {
        try {
            this.sock = new Socket(this.host, this.port);
            this.in = new BufferedReader(new InputStreamReader(this.sock.getInputStream(), "UTF-8"));
            this.out = new BufferedWriter(new OutputStreamWriter(this.sock.getOutputStream(), "UTF-8"));
            return true;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return false;
        }
    }

    public String process(String data) {
        try {
            int ch;
            this.out.write(data);
            this.out.write(0);
            this.out.flush();
            String tagged = "";
            while ((ch = this.in.read()) != 0) {
                tagged = tagged + (char)ch;
            }
            return tagged;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return "";
        }
    }

    public void close() {
        try {
            this.sock.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("TaggingClient [inputfile] [outputfile]");
            return;
        }
        try {
            String line;
            TaggingClient client = new TaggingClient("localhost", 2929);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(args[0]), "UTF-8"));
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(args[1]), "UTF-8"));
            client.connect();
            String input = "";
            while ((line = reader.readLine()) != null) {
                input = input + line + "\n";
            }
            String tagged = client.process(input);
            writer.write(tagged + "\n");
            client.close();
            reader.close();
            writer.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

