/*
 * Decompiled with CFR 0.152.
 */
package jvntextpro.data;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import jvntextpro.data.DataReader;
import jvntextpro.data.Sentence;
import jvntextpro.data.TaggingData;

public abstract class TrainDataGenerating {
    protected DataReader reader;
    protected TaggingData tagger;

    public abstract void init();

    public void generateTrainData(String inputPath, String outputPath) {
        try {
            File file = new File(inputPath);
            ArrayList data = new ArrayList();
            if (file.isFile()) {
                System.out.println("Reading " + file.getName());
                data = (ArrayList)this.reader.readFile(inputPath);
            } else if (file.isDirectory()) {
                String[] filenames;
                for (String filename : filenames = file.list()) {
                    System.out.println("Reading " + filename);
                    ArrayList temp = (ArrayList)this.reader.readFile(file.getPath() + File.separator + filename);
                    data.addAll(temp);
                }
            }
            String result = "";
            System.out.println(data.size() + "sentences read");
            for (int i = 0; i < data.size(); ++i) {
                if (i % 20 == 0) {
                    System.out.println("Finished " + i + " in " + data.size() + " sentences");
                }
                Sentence sent = (Sentence)data.get(i);
                for (int j = 0; j < sent.size(); ++j) {
                    String line = "";
                    String context = this.tagger.getContextStr(sent, j);
                    line = context + " ";
                    line = line + sent.getTagAt(j);
                    result = result + line + "\n";
                }
                result = result + "\n";
            }
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputPath + ".tagged"), "UTF-8"));
            writer.write(result);
            writer.close();
        }
        catch (Exception e) {
            System.out.println("Error while generating training data");
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

