/*
 * Decompiled with CFR 0.152.
 */
package jvntextpro.conversion;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class CompositeUnicode2Unicode {
    Map<String, String> cpsUni2Uni;
    private static final String DEFAULT_MAP_RESOURCE = "jvntextpro/conversion/Composite2Unicode.txt";

    public CompositeUnicode2Unicode() {
        try {
            String line;
            this.cpsUni2Uni = new HashMap<String, String>();
            URL url = CompositeUnicode2Unicode.class.getClassLoader().getResource(DEFAULT_MAP_RESOURCE);
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
            while ((line = reader.readLine()) != null) {
                String[] onemap = line.split("\t");
                if (onemap.length != 2) continue;
                this.cpsUni2Uni.put(onemap[0], onemap[1]);
            }
            reader.close();
        }
        catch (Exception e) {
            System.err.println("Loading composite to unicode map fail: " + e.getMessage());
            this.cpsUni2Uni = null;
        }
    }

    public String convert(String text) {
        String ret = text;
        if (this.cpsUni2Uni == null) {
            return ret;
        }
        for (String cpsChar : this.cpsUni2Uni.keySet()) {
            ret = ret.replaceAll(cpsChar, this.cpsUni2Uni.get(cpsChar));
        }
        return ret;
    }
}

