/*
 * Decompiled with CFR 0.152.
 */
package jvnsegmenter;

import java.util.ArrayList;
import java.util.Vector;
import jvnsegmenter.BasicContextGenerator;
import jvntextpro.data.Sentence;
import jvntextpro.util.StringUtils;
import org.w3c.dom.Element;

public class SyllableContextGenerator
extends BasicContextGenerator {
    public SyllableContextGenerator(Element node) {
        this.readFeatureParameters(node);
    }

    @Override
    public String[] getContext(Sentence sent, int pos) {
        ArrayList<String> cps = new ArrayList<String>();
        for (int it = 0; it < this.cpnames.size(); ++it) {
            String cp = (String)this.cpnames.get(it);
            Vector paras = (Vector)this.paras.get(it);
            String cpvalue = "";
            if (cp.equals("initial_cap")) {
                cpvalue = this.ic(sent, pos, (Integer)paras.get(0));
            } else if (cp.equals("all_cap")) {
                cpvalue = this.ac(sent, pos, (Integer)paras.get(0));
            } else if (cp.equals("mark")) {
                cpvalue = this.mk(sent, pos, (Integer)paras.get(0));
            } else if (cp.equals("first_obsrv") && pos + (Integer)paras.get(0) == 0) {
                cpvalue = "fi:" + paras.get(0);
            }
            if (cpvalue.equals("")) continue;
            cps.add(cpvalue);
        }
        String[] ret = new String[cps.size()];
        return cps.toArray(ret);
    }

    private String ic(Sentence sent, int pos, int i) {
        String cp;
        if (0 <= pos + i && pos + i < sent.size()) {
            String word = sent.getWordAt(pos + i);
            cp = "ic:" + word;
            if (!StringUtils.isFirstCap(word)) {
                cp = "";
            }
        } else {
            cp = "";
        }
        return cp;
    }

    private String ac(Sentence sent, int pos, int i) {
        String cp;
        if (0 <= pos + i && pos + i < sent.size()) {
            String word = sent.getWordAt(pos + i);
            cp = "ac:" + word;
            boolean isAllCap = true;
            for (int j = 0; j < word.length(); ++j) {
                if (word.charAt(j) == '_' || word.charAt(j) == '.' || Character.isUpperCase(word.charAt(j))) continue;
                isAllCap = false;
                break;
            }
            if (!isAllCap) {
                cp = "";
            }
        } else {
            cp = "";
        }
        return cp;
    }

    private String mk(Sentence sent, int pos, int i) {
        String cp;
        if (0 <= pos + i && pos + i < sent.size()) {
            String word = sent.getWordAt(pos + i);
            cp = "ma:" + word;
            if (!StringUtils.isPunc(word)) {
                cp = "";
            }
        } else {
            cp = "";
        }
        return cp;
    }
}

