/*
 * Decompiled with CFR 0.152.
 */
package jvnsegmenter;

import java.io.File;
import java.util.Vector;
import jflexcrf.Labeling;
import jvnsegmenter.BasicContextGenerator;
import jvnsegmenter.ConjunctionContextGenerator;
import jvnsegmenter.LexiconContextGenerator;
import jvnsegmenter.RegexContextGenerator;
import jvnsegmenter.SyllableContextGenerator;
import jvnsegmenter.VietnameseContextGenerator;
import jvnsegmenter.WordDataReader;
import jvnsegmenter.WordDataWriter;
import jvntextpro.data.DataReader;
import jvntextpro.data.DataWriter;
import jvntextpro.data.TaggingData;
import org.w3c.dom.Element;

public class CRFSegmenter {
    DataReader reader = new WordDataReader();
    DataWriter writer = new WordDataWriter();
    TaggingData dataTagger = new TaggingData();
    Labeling labeling = null;

    public CRFSegmenter(String modelDir) {
        this.init(modelDir);
    }

    public CRFSegmenter() {
    }

    public void init(String modelDir) {
        String templateFile = modelDir + File.separator + "featuretemplate.xml";
        Vector<Element> nodes = BasicContextGenerator.readFeatureNodes(templateFile);
        for (int i = 0; i < nodes.size(); ++i) {
            Element node = nodes.get(i);
            String cpType = node.getAttribute("value");
            BasicContextGenerator contextGen = null;
            if (cpType.equals("Conjunction")) {
                contextGen = new ConjunctionContextGenerator(node);
            } else if (cpType.equals("Lexicon")) {
                contextGen = new LexiconContextGenerator(node);
                LexiconContextGenerator.loadVietnameseDict(modelDir + File.separator + "VNDic_UTF-8.txt");
                LexiconContextGenerator.loadViLocationList(modelDir + File.separator + "vnlocations.txt");
                LexiconContextGenerator.loadViPersonalNames(modelDir + File.separator + "vnpernames.txt");
            } else if (cpType.equals("Regex")) {
                contextGen = new RegexContextGenerator(node);
            } else if (cpType.equals("SyllableFeature")) {
                contextGen = new SyllableContextGenerator(node);
            } else if (cpType.equals("ViSyllableFeature")) {
                contextGen = new VietnameseContextGenerator(node);
            }
            if (contextGen == null) continue;
            this.dataTagger.addContextGenerator(contextGen);
        }
        this.labeling = new Labeling(modelDir, this.dataTagger, this.reader, this.writer);
    }

    public String segmenting(String instr) {
        return this.labeling.strLabeling(instr);
    }

    public String segmenting(File file) {
        return this.labeling.strLabeling(file);
    }

    public void setDataReader(DataReader reader) {
        this.reader = reader;
    }

    public void setDataWriter(DataWriter writer) {
        this.writer = writer;
    }
}

