/*
 * Decompiled with CFR 0.152.
 */
package jvnpostag;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jvntextpro.data.ContextGenerator;
import jvntextpro.data.Sentence;
import jvntextpro.util.StringUtils;
import jvntextpro.util.VnSyllParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class POSContextGenerator
extends ContextGenerator {
    private static final String DEFAULT_E_DICT = "jvnpostag/ComputerDict.txt";
    Map word2dictags = new HashMap();
    Vector<String> cpnames;
    Vector<Vector<Integer>> paras;

    public POSContextGenerator(String featureTemplateFile) {
        this.readDict();
        this.readFeatureTemplate(featureTemplateFile);
    }

    @Override
    public String[] getContext(Sentence sent, int pos) {
        ArrayList<String> cps = new ArrayList<String>();
        for (int it = 0; it < this.cpnames.size(); ++it) {
            String cp = this.cpnames.get(it);
            Vector<Integer> paras = this.paras.get(it);
            String cpvalue = "";
            if (cp.equals("w")) {
                cpvalue = this.w(sent, pos, paras.get(0));
            } else if (cp.equals("wj")) {
                cpvalue = this.wj(sent, pos, paras.get(0), paras.get(1));
            } else if (cp.equals("prf")) {
                cpvalue = this.prf(sent, pos, paras.get(0));
            } else if (cp.equals("sff")) {
                cpvalue = this.sff(sent, pos, paras.get(0));
            } else if (cp.equals("an")) {
                cpvalue = this.an(sent, pos, paras.get(0));
            } else if (cp.equals("hn")) {
                cpvalue = this.hn(sent, pos, paras.get(0));
            } else if (cp.equals("hyph")) {
                cpvalue = this.hyph(sent, pos, paras.get(0));
            } else if (cp.equals("slash")) {
                cpvalue = this.slash(sent, pos, paras.get(0));
            } else if (cp.equals("com")) {
                cpvalue = this.com(sent, pos, paras.get(0));
            } else if (cp.equals("ac")) {
                cpvalue = this.ac(sent, pos, paras.get(0));
            } else if (cp.equals("ic")) {
                cpvalue = this.ic(sent, pos, paras.get(0));
            } else if (cp.equals("mk")) {
                cpvalue = this.mk(sent, pos, paras.get(0));
            } else if (cp.equals("dict")) {
                cps.add(this.dict(sent, pos, paras.get(0)));
            } else if (cp.equals("rr")) {
                cpvalue = this.rr(sent, pos, paras.get(0));
            }
            if (cpvalue.equals("")) continue;
            cps.add(cpvalue);
        }
        String[] ret = new String[cps.size()];
        return cps.toArray(ret);
    }

    public boolean readDict() {
        try {
            String line;
            URL url = POSContextGenerator.class.getClassLoader().getResource(DEFAULT_E_DICT);
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
            this.word2dictags.clear();
            String temp = null;
            while ((line = reader.readLine()) != null) {
                String tag;
                String word;
                String[] tokens = line.split("\t");
                if (tokens == null || tokens.length != 2 || tokens.length != 2) continue;
                if (tokens[0].equals("")) {
                    if (temp == null) continue;
                    word = temp;
                    tag = tokens[1];
                } else {
                    word = tokens[0].trim().toLowerCase();
                    tag = tokens[1].trim();
                    temp = word;
                }
                word = word.replace(" ", "_");
                ArrayList<String> dictags = (ArrayList<String>)this.word2dictags.get(word);
                if (dictags == null) {
                    dictags = new ArrayList<String>();
                }
                dictags.add(tag);
                this.word2dictags.put(word, dictags);
            }
            reader.close();
            return true;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public boolean readFeatureTemplate(String file) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            FileInputStream stream = new FileInputStream(file);
            Document doc = builder.parse(stream);
            Element root = doc.getDocumentElement();
            NodeList childrent = root.getChildNodes();
            this.cpnames = new Vector();
            this.paras = new Vector();
            for (int i = 0; i < childrent.getLength(); ++i) {
                if (!(childrent.item(i) instanceof Element)) continue;
                Element child = (Element)childrent.item(i);
                String value = child.getAttribute("value");
                String[] parastr = value.split(":");
                Vector<Integer> para = new Vector<Integer>();
                for (int j = 1; j < parastr.length; ++j) {
                    para.add(Integer.parseInt(parastr[j]));
                }
                this.cpnames.add(parastr[0]);
                this.paras.add(para);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private String w(Sentence sent, int pos, int i) {
        String cp = "w:" + Integer.toString(i) + ":";
        cp = 0 <= pos + i && pos + i < sent.size() ? cp + sent.getWordAt(pos + i) : "";
        return cp;
    }

    private String wj(Sentence sent, int pos, int i, int j) {
        String cp = "wj:" + Integer.toString(i) + ":" + Integer.toString(j) + ":";
        cp = pos + i >= sent.size() || pos + i < 0 || pos + j < 0 || pos + j >= sent.size() ? "" : cp + sent.getWordAt(pos + i) + ":" + sent.getWordAt(pos + j);
        return cp;
    }

    private String prf(Sentence sent, int pos, int i) {
        String cp;
        if (0 <= pos + i && pos + i < sent.size()) {
            cp = "prf:" + Integer.toString(i) + ":";
            String word = sent.getWordAt(pos + i);
            String[] sylls = word.split("_");
            cp = sylls.length >= 2 ? cp + sylls[0] : "";
        } else {
            cp = "";
        }
        return cp;
    }

    private String sff(Sentence sent, int pos, int i) {
        String cp;
        if (0 <= pos + i && pos + i < sent.size()) {
            cp = "sff:" + Integer.toString(i) + ":";
            String word = sent.getWordAt(pos + i);
            String[] sylls = word.split("_");
            cp = sylls.length >= 2 ? cp + sylls[sylls.length - 1] : "";
        } else {
            cp = "";
        }
        return cp;
    }

    private String an(Sentence sent, int pos, int i) {
        String cp;
        if (0 <= pos + i && pos + i < sent.size()) {
            cp = "an:" + Integer.toString(i);
            String word = sent.getWordAt(pos + i);
            if (!StringUtils.isAllNumber(word)) {
                cp = "";
            }
        } else {
            cp = "";
        }
        return cp;
    }

    private String hn(Sentence sent, int pos, int i) {
        String cp;
        if (0 <= pos + i && pos + i < sent.size()) {
            cp = "hn:" + Integer.toString(i);
            String word = sent.getWordAt(pos + i);
            if (!StringUtils.containNumber(word)) {
                cp = "";
            }
        } else {
            cp = "";
        }
        return cp;
    }

    private String hyph(Sentence sent, int pos, int i) {
        String cp;
        if (0 <= pos + i && pos + i < sent.size()) {
            cp = "hyph:" + Integer.toString(i);
            String word = sent.getWordAt(pos + i);
            if (!word.contains("-")) {
                cp = "";
            }
        } else {
            cp = "";
        }
        return cp;
    }

    private String slash(Sentence sent, int pos, int i) {
        String cp;
        if (0 <= pos + i && pos + i < sent.size()) {
            cp = "hyph:" + Integer.toString(i);
            String word = sent.getWordAt(pos + i);
            if (!word.contains("/")) {
                cp = "";
            }
        } else {
            cp = "";
        }
        return cp;
    }

    private String com(Sentence sent, int pos, int i) {
        String cp;
        if (0 <= pos + i && pos + i < sent.size()) {
            cp = "hyph:" + Integer.toString(i);
            String word = sent.getWordAt(pos + i);
            if (!word.contains(":")) {
                cp = "";
            }
        } else {
            cp = "";
        }
        return cp;
    }

    private String ac(Sentence sent, int pos, int i) {
        String cp;
        if (0 <= pos + i && pos + i < sent.size()) {
            cp = "ac:" + Integer.toString(i);
            String word = sent.getWordAt(pos + i);
            boolean isAllCap = true;
            for (int j = 0; j < word.length(); ++j) {
                if (word.charAt(j) == '_' || word.charAt(j) == '.' || Character.isUpperCase(word.charAt(j))) continue;
                isAllCap = false;
                break;
            }
            if (!isAllCap) {
                cp = "";
            }
        } else {
            cp = "";
        }
        return cp;
    }

    private String ic(Sentence sent, int pos, int i) {
        String cp;
        if (0 <= pos + i && pos + i < sent.size()) {
            cp = "ic:" + Integer.toString(i);
            String word = sent.getWordAt(pos + i);
            if (!StringUtils.isFirstCap(word)) {
                cp = "";
            }
        } else {
            cp = "";
        }
        return cp;
    }

    private String mk(Sentence sent, int pos, int i) {
        String cp;
        if (0 <= pos + i && pos + i < sent.size()) {
            cp = "mk:" + Integer.toString(i);
            String word = sent.getWordAt(pos + i);
            if (!StringUtils.isPunc(word)) {
                cp = "";
            }
        } else {
            cp = "";
        }
        return cp;
    }

    private String dict(Sentence sent, int pos, int i) {
        String word;
        String cp = "";
        if (0 <= pos + i && pos + i < sent.size() && this.word2dictags.containsKey(word = sent.getWordAt(pos + i))) {
            List tags = (List)this.word2dictags.get(word);
            for (int j = 0; j < tags.size(); ++j) {
                cp = cp + "dict:" + Integer.toString(i) + ":" + tags.get(j) + " ";
            }
        }
        return cp.trim();
    }

    private String rr(Sentence sent, int pos, int i) {
        String word;
        String[] sylls;
        String cp = "";
        if (0 <= pos + i && pos + i < sent.size() && (sylls = (word = sent.getWordAt(pos + i)).split("_")).length == 2) {
            VnSyllParser parser1 = new VnSyllParser(sylls[0]);
            VnSyllParser parser2 = new VnSyllParser(sylls[1]);
            if (parser1.isValidVnSyllable() && parser2.isValidVnSyllable()) {
                if (parser1.getNonToneSyll().equalsIgnoreCase(parser2.getNonToneSyll())) {
                    cp = cp + "fr:" + Integer.toString(i) + " ";
                } else if (parser1.getRhyme().equalsIgnoreCase(parser2.getRhyme())) {
                    cp = cp + "pr:" + Integer.toString(i) + " ";
                }
            }
        }
        return cp.trim();
    }
}

