/*
 * Decompiled with CFR 0.152.
 */
package jvnpostag;

import java.io.File;
import java.util.List;
import jmaxent.Classification;
import jvnpostag.POSContextGenerator;
import jvnpostag.POSDataReader;
import jvnpostag.POSDataWriter;
import jvnpostag.POSTagger;
import jvntextpro.data.DataReader;
import jvntextpro.data.DataWriter;
import jvntextpro.data.Sentence;
import jvntextpro.data.TaggingData;
import jvntextpro.util.StringUtils;

public class MaxentTagger
implements POSTagger {
    DataReader reader = new POSDataReader();
    DataWriter writer = new POSDataWriter();
    TaggingData dataTagger = new TaggingData();
    Classification classifier = null;

    public MaxentTagger(String modelDir) {
        this.init(modelDir);
    }

    @Override
    public void init(String modeldir) {
        this.dataTagger.addContextGenerator(new POSContextGenerator(modeldir + File.separator + "featuretemplate.xml"));
        this.classifier = new Classification(modeldir);
    }

    @Override
    public String tagging(String instr) {
        System.out.println("tagging ....");
        List<Sentence> data = this.reader.readString(instr);
        for (int i = 0; i < data.size(); ++i) {
            Sentence sent = data.get(i);
            for (int j = 0; j < sent.size(); ++j) {
                String[] cps = this.dataTagger.getContext(sent, j);
                String label = this.classifier.classify(cps);
                if (label.equalsIgnoreCase("Mrk")) {
                    label = StringUtils.isPunc(sent.getWordAt(j)) ? sent.getWordAt(j) : "X";
                }
                sent.getTWordAt(j).setTag(label);
            }
        }
        return this.writer.writeString(data);
    }

    @Override
    public String tagging(File file) {
        List<Sentence> data = this.reader.readFile(file.getPath());
        for (int i = 0; i < data.size(); ++i) {
            Sentence sent = data.get(i);
            for (int j = 0; j < sent.size(); ++j) {
                String[] cps = this.dataTagger.getContext(sent, j);
                String label = this.classifier.classify(cps);
                if (label.equalsIgnoreCase("Mrk")) {
                    label = StringUtils.isPunc(sent.getWordAt(j)) ? sent.getWordAt(j) : "X";
                }
                sent.getTWordAt(j).setTag(label);
            }
        }
        return this.writer.writeString(data);
    }

    @Override
    public void setDataReader(DataReader reader) {
        this.reader = reader;
    }

    @Override
    public void setDataWriter(DataWriter writer) {
        this.writer = writer;
    }
}

