/*
 * Decompiled with CFR 0.152.
 */
package jvnpostag;

import java.io.File;
import jflexcrf.Labeling;
import jvnpostag.POSContextGenerator;
import jvnpostag.POSDataReader;
import jvnpostag.POSDataWriter;
import jvnpostag.POSTagger;
import jvntextpro.data.DataReader;
import jvntextpro.data.DataWriter;
import jvntextpro.data.TaggingData;

public class CRFTagger
implements POSTagger {
    DataReader reader = new POSDataReader();
    DataWriter writer = new POSDataWriter();
    TaggingData dataTagger = new TaggingData();
    Labeling labeling = null;

    public CRFTagger(String modelDir) {
        this.init(modelDir);
    }

    @Override
    public void init(String modelDir) {
        this.dataTagger.addContextGenerator(new POSContextGenerator(modelDir + File.separator + "featuretemplate.xml"));
        this.labeling = new Labeling(modelDir, this.dataTagger, this.reader, this.writer);
    }

    @Override
    public String tagging(String instr) {
        return this.labeling.strLabeling(instr);
    }

    @Override
    public String tagging(File file) {
        return this.labeling.strLabeling(file);
    }

    @Override
    public void setDataReader(DataReader reader) {
        this.reader = reader;
    }

    @Override
    public void setDataWriter(DataWriter writer) {
        this.writer = writer;
    }
}

