/*
 * Decompiled with CFR 0.152.
 */
package jmaxent;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import jmaxent.Data;
import jmaxent.Dictionary;
import jmaxent.Evaluation;
import jmaxent.FeatureGen;
import jmaxent.Inference;
import jmaxent.Model;
import jmaxent.Option;
import jmaxent.Train;

public class Trainer {
    public static void main(String[] args) throws IOException {
        PrintWriter flog;
        if (!Trainer.checkArgs(args)) {
            Trainer.displayHelp();
            return;
        }
        String modelDir = args[2];
        boolean isAll = args[0].compareToIgnoreCase("-all") == 0;
        boolean isTrn = args[0].compareToIgnoreCase("-trn") == 0;
        boolean isTst = args[0].compareToIgnoreCase("-tst") == 0;
        boolean isCont = args[0].compareToIgnoreCase("-cont") == 0;
        Option option = new Option(modelDir);
        option.optionFile = args[4];
        option.readOptions();
        Data data = null;
        Dictionary dict = null;
        FeatureGen feaGen = null;
        Train train = null;
        Inference inference = null;
        Evaluation evaluation = null;
        Model model = null;
        PrintWriter foutModel = null;
        BufferedReader finModel = null;
        if (isAll) {
            flog = option.openTrainLogFile();
            if (flog == null) {
                System.out.println("Couldn't create training log file");
                return;
            }
            foutModel = option.createModelFile();
            if (foutModel == null) {
                System.out.println("Couldn't create model file");
                return;
            }
            data = new Data(option);
            data.readTrnData(option.modelDir + File.separator + option.trainDataFile);
            data.readTstData(option.modelDir + File.separator + option.testDataFile);
            dict = new Dictionary(option, data);
            dict.generateDict();
            feaGen = new FeatureGen(option, data, dict);
            feaGen.generateFeatures();
            data.writeCpMaps(dict, foutModel);
            data.writeLbMaps(foutModel);
            train = new Train();
            inference = new Inference();
            evaluation = new Evaluation();
            model = new Model(option, data, dict, feaGen, train, inference, evaluation);
            model.doTrain(flog);
            model.doInference(model.data.tstData);
            model.evaluation.evaluate(flog);
            dict.writeDict(foutModel);
            feaGen.writeFeatures(foutModel);
            foutModel.close();
        }
        if (isTrn) {
            flog = option.openTrainLogFile();
            if (flog == null) {
                System.out.println("Couldn't create training log file");
                return;
            }
            foutModel = option.createModelFile();
            if (foutModel == null) {
                System.out.println("Couldn't create model file");
                return;
            }
            data = new Data(option);
            data.readTrnData(option.modelDir + File.separator + option.trainDataFile);
            dict = new Dictionary(option, data);
            dict.generateDict();
            feaGen = new FeatureGen(option, data, dict);
            feaGen.generateFeatures();
            data.writeCpMaps(dict, foutModel);
            data.writeLbMaps(foutModel);
            train = new Train();
            model = new Model(option, data, dict, feaGen, train, null, null);
            model.doTrain(flog);
            dict.writeDict(foutModel);
            feaGen.writeFeatures(foutModel);
            foutModel.close();
        }
        if (isTst) {
            finModel = option.openModelFile();
            if (finModel == null) {
                System.out.println("Couldn't open model file");
                return;
            }
            data = new Data(option);
            data.readCpMaps(finModel);
            data.readLbMaps(finModel);
            data.readTstData(option.modelDir + File.separator + option.testDataFile);
            dict = new Dictionary(option, data);
            dict.readDict(finModel);
            feaGen = new FeatureGen(option, data, dict);
            feaGen.readFeatures(finModel);
            inference = new Inference();
            evaluation = new Evaluation();
            model = new Model(option, data, dict, feaGen, null, inference, evaluation);
            model.doInference(model.data.tstData);
            model.evaluation.evaluate(null);
            finModel.close();
        }
        if (isCont) {
            flog = option.openTrainLogFile();
            if (flog == null) {
                System.out.println("Couldn't create training log file");
                return;
            }
            finModel = option.openModelFile();
            if (finModel == null) {
                System.out.println("Couldn't open model file");
                return;
            }
            data = new Data(option);
            data.readCpMaps(finModel);
            data.readLbMaps(finModel);
            data.readTstData(option.modelDir + File.separator + option.testDataFile);
            dict = new Dictionary(option, data);
            dict.readDict(finModel);
            feaGen = new FeatureGen(option, data, dict);
            feaGen.readFeatures(finModel);
            inference = new Inference();
            evaluation = new Evaluation();
            foutModel = option.createModelFile();
            if (foutModel == null) {
                System.out.println("Couldn't create model file");
                return;
            }
            model = new Model(option, data, dict, feaGen, train, inference, evaluation);
            model.doTrain(flog);
            model.doInference(model.data.tstData);
            model.evaluation.evaluate(flog);
            foutModel.close();
        }
    }

    public static boolean checkArgs(String[] args) {
        if (args.length < 5) {
            return false;
        }
        if (args[0].compareToIgnoreCase("-all") != 0 && args[0].compareToIgnoreCase("-trn") != 0 && args[0].compareToIgnoreCase("-tst") != 0 || args[0].compareToIgnoreCase("-cont") == 0) {
            return false;
        }
        if (args[1].compareToIgnoreCase("-d") != 0) {
            return false;
        }
        return args[3].compareToIgnoreCase("-o") == 0;
    }

    public static void displayHelp() {
        System.out.println("Usage:");
        System.out.println("\tTrainer -all/-trn/-tst -d <model directory> -o <optionFile>");
    }
}

