/*
 * Decompiled with CFR 0.152.
 */
package jmaxent;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class Option {
    public String modelDir = ".";
    public String modelFile = "model.txt";
    public static String modelSeparator = "##########";
    public String optionFile = "option.txt";
    public String trainDataFile = "train.labeled";
    public String testDataFile = "test.labeled";
    public static String labelSeparator = "/";
    public String trainLogFile = "trainlog.txt";
    public boolean isLogging = true;
    public int numTrainExps = 0;
    public int numTestExps = 0;
    public int numLabels = 0;
    public int numCps = 0;
    public int numFeatures = 0;
    public int cpRareThreshold = 1;
    public int fRareThreshold = 1;
    public int numIterations = 100;
    public double initLambdaVal = 0.0;
    public double sigmaSquare = 100.0;
    public double epsForConvergence = 1.0E-4;
    public int mForHessian = 7;
    public int debugLevel = 1;
    public boolean evaluateDuringTraining = true;
    public boolean saveBestModel = true;

    public Option() {
    }

    public Option(String modelDir) {
        this.modelDir = modelDir.endsWith(File.separator) ? modelDir.substring(0, modelDir.length() - 1) : modelDir;
    }

    public boolean readOptions() {
        String filename = this.modelDir + File.separator + this.optionFile;
        BufferedReader fin = null;
        try {
            String line;
            fin = new BufferedReader(new FileReader(filename));
            System.out.println("Reading options ...");
            while ((line = fin.readLine()) != null) {
                StringTokenizer strTok;
                int len;
                String trimLine = line.trim();
                if (trimLine.startsWith("#") || (len = (strTok = new StringTokenizer(line, "= \t\r\n")).countTokens()) != 2) continue;
                String strOpt = strTok.nextToken();
                String strVal = strTok.nextToken();
                if (strOpt.compareToIgnoreCase("trainDataFile") == 0) {
                    this.trainDataFile = strVal;
                    continue;
                }
                if (strOpt.compareToIgnoreCase("testDataFile") == 0) {
                    this.testDataFile = strVal;
                    continue;
                }
                if (strOpt.compareToIgnoreCase("isLogging") == 0) {
                    if (strVal.compareToIgnoreCase("true") != 0 && strVal.compareToIgnoreCase("false") != 0) continue;
                    this.isLogging = Boolean.valueOf(strVal);
                    continue;
                }
                if (strOpt.compareToIgnoreCase("cpRareThreshold") == 0) {
                    int numTemp;
                    this.cpRareThreshold = numTemp = Integer.parseInt(strVal);
                    continue;
                }
                if (strOpt.compareToIgnoreCase("fRareThreshold") == 0) {
                    int numTemp;
                    this.fRareThreshold = numTemp = Integer.parseInt(strVal);
                    continue;
                }
                if (strOpt.compareToIgnoreCase("numIterations") == 0) {
                    int numTemp;
                    this.numIterations = numTemp = Integer.parseInt(strVal);
                    continue;
                }
                if (strOpt.compareToIgnoreCase("initLambdaVal") == 0) {
                    double numTemp;
                    this.initLambdaVal = numTemp = Double.parseDouble(strVal);
                    continue;
                }
                if (strOpt.compareToIgnoreCase("sigmaSquare") == 0) {
                    double numTemp;
                    this.sigmaSquare = numTemp = Double.parseDouble(strVal);
                    continue;
                }
                if (strOpt.compareToIgnoreCase("epsForConvergence") == 0) {
                    double numTemp;
                    this.epsForConvergence = numTemp = Double.parseDouble(strVal);
                    continue;
                }
                if (strOpt.compareToIgnoreCase("mForHessian") == 0) {
                    int numTemp;
                    this.mForHessian = numTemp = Integer.parseInt(strVal);
                    continue;
                }
                if (strOpt.compareToIgnoreCase("evaluateDuringTraining") == 0) {
                    if (strVal.compareToIgnoreCase("true") != 0 && strVal.compareToIgnoreCase("false") != 0) continue;
                    this.evaluateDuringTraining = Boolean.valueOf(strVal);
                    continue;
                }
                if (strOpt.compareToIgnoreCase("saveBestModel") == 0) {
                    if (strVal.compareToIgnoreCase("true") != 0 && strVal.compareToIgnoreCase("false") != 0) continue;
                    this.saveBestModel = Boolean.valueOf(strVal);
                    continue;
                }
                if (strOpt.compareToIgnoreCase("trainLogFile") == 0) {
                    this.trainLogFile = strVal;
                    continue;
                }
                if (strOpt.compareToIgnoreCase("modelFile") != 0) continue;
                this.modelFile = strVal;
            }
            System.out.println("Reading options completed!");
        }
        catch (IOException e) {
            System.out.println(e.toString());
            return false;
        }
        return true;
    }

    public PrintWriter openTrainLogFile() {
        String filename = this.modelDir + File.separator + this.trainLogFile;
        PrintWriter fout = null;
        try {
            fout = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8"));
        }
        catch (IOException e) {
            System.out.println(e.toString());
            return null;
        }
        return fout;
    }

    public BufferedReader openModelFile() {
        String filename = this.modelDir + File.separator + this.modelFile;
        BufferedReader fin = null;
        try {
            fin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
        }
        catch (IOException e) {
            System.out.println(e.toString());
            return null;
        }
        return fin;
    }

    public PrintWriter createModelFile() {
        String filename = this.modelDir + File.separator + this.modelFile;
        PrintWriter fout = null;
        try {
            fout = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8"));
        }
        catch (IOException e) {
            System.out.println(e.toString());
            return null;
        }
        return fout;
    }

    public void writeOptions(PrintWriter fout) {
        fout.println("OPTION VALUES:");
        fout.println("==============");
        fout.println("Model directory: " + this.modelDir);
        fout.println("Model file: " + this.modelFile);
        fout.println("Option file: " + this.optionFile);
        fout.println("Training log file: " + this.trainLogFile + " (this one)");
        fout.println("Training data file: " + this.trainDataFile);
        fout.println("Testing data file: " + this.testDataFile);
        fout.println("Number of training examples " + Integer.toString(this.numTrainExps));
        fout.println("Number of testing examples " + Integer.toString(this.numTestExps));
        fout.println("Number of class labels: " + Integer.toString(this.numLabels));
        fout.println("Number of context predicates: " + Integer.toString(this.numCps));
        fout.println("Number of features: " + Integer.toString(this.numFeatures));
        fout.println("Rare threshold for context predicates: " + Integer.toString(this.cpRareThreshold));
        fout.println("Rare threshold for features: " + Integer.toString(this.fRareThreshold));
        fout.println("Number of training iterations: " + Integer.toString(this.numIterations));
        fout.println("Initial value of feature weights: " + Double.toString(this.initLambdaVal));
        fout.println("Sigma square: " + Double.toString(this.sigmaSquare));
        fout.println("Epsilon for convergence: " + Double.toString(this.epsForConvergence));
        fout.println("Number of corrections in L-BFGS: " + Integer.toString(this.mForHessian));
        if (this.evaluateDuringTraining) {
            fout.println("Evaluation during training: true");
        } else {
            fout.println("Evaluation during training: false");
        }
        if (this.saveBestModel) {
            fout.println("Save the best model towards testing data: true");
        } else {
            fout.println("Save the best model towards testing data: false");
        }
        fout.println();
    }
}

