/*
 * Decompiled with CFR 0.152.
 */
package jmaxent;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jmaxent.CountFIdx;
import jmaxent.Data;
import jmaxent.Dictionary;
import jmaxent.Element;
import jmaxent.Feature;
import jmaxent.Observation;
import jmaxent.Option;

public class FeatureGen {
    List features = null;
    Map fmap = null;
    Option option = null;
    Data data = null;
    Dictionary dict = null;
    List currentFeatures = null;
    int currentFeatureIdx = 0;

    public FeatureGen(Option option, Data data, Dictionary dict) {
        this.option = option;
        this.data = data;
        this.dict = dict;
    }

    public void addFeature(Feature f) {
        f.strId2IdxAdd(this.fmap);
        this.features.add(f);
    }

    public void generateFeatures() {
        if (this.features != null) {
            this.features.clear();
        } else {
            this.features = new ArrayList();
        }
        if (this.fmap != null) {
            this.fmap.clear();
        } else {
            this.fmap = new HashMap();
        }
        if (this.currentFeatures != null) {
            this.currentFeatures.clear();
        } else {
            this.currentFeatures = new ArrayList();
        }
        if (this.data.trnData == null || this.dict.dict == null) {
            System.out.println("No data or dictionary for generating features");
            return;
        }
        for (int i = 0; i < this.data.trnData.size(); ++i) {
            Observation obsr = (Observation)this.data.trnData.get(i);
            for (int j = 0; j < obsr.cps.length; ++j) {
                Element elem = null;
                CountFIdx cntFIdx = null;
                elem = (Element)this.dict.dict.get(new Integer(obsr.cps[j]));
                if (elem == null || elem.count <= this.option.cpRareThreshold || (cntFIdx = (CountFIdx)elem.lbCntFidxes.get(new Integer(obsr.humanLabel))) == null || cntFIdx.count <= this.option.fRareThreshold) continue;
                Feature f = new Feature(obsr.humanLabel, obsr.cps[j]);
                f.strId2Idx(this.fmap);
                if (f.idx >= 0) continue;
                this.addFeature(f);
                cntFIdx.fidx = f.idx;
                elem.chosen = 1;
            }
        }
        this.option.numFeatures = this.features.size();
    }

    public int numFeatures() {
        if (this.features == null) {
            return 0;
        }
        return this.features.size();
    }

    public void readFeatures(BufferedReader fin) throws IOException {
        if (this.features != null) {
            this.features.clear();
        } else {
            this.features = new ArrayList();
        }
        if (this.fmap != null) {
            this.fmap.clear();
        } else {
            this.fmap = new HashMap();
        }
        if (this.currentFeatures != null) {
            this.currentFeatures.clear();
        } else {
            this.currentFeatures = new ArrayList();
        }
        String line = fin.readLine();
        if (line == null) {
            System.out.println("Unknown number of features");
            return;
        }
        int numFeatures = Integer.parseInt(line);
        if (numFeatures <= 0) {
            System.out.println("Invalid number of features");
            return;
        }
        System.out.println("Reading features ...");
        for (int i = 0; i < numFeatures; ++i) {
            line = fin.readLine();
            if (line == null) continue;
            StringTokenizer strTok = new StringTokenizer(line, " ");
            if (strTok.countTokens() != 4) {
                System.out.println(i + " invalid feature line ");
                continue;
            }
            Feature f = new Feature(line, this.data.cpStr2Int, this.data.lbStr2Int);
            Integer fidx = (Integer)this.fmap.get(f.strId);
            if (fidx == null) {
                this.fmap.put(f.strId, new Integer(f.idx));
                this.features.add(f);
                continue;
            }
            this.fmap.put(f.strId, new Integer(f.idx));
            this.features.add(f);
        }
        System.out.println("Reading " + Integer.toString(this.features.size()) + " features completed!");
        line = fin.readLine();
        this.option.numFeatures = this.features.size();
    }

    public void writeFeatures(PrintWriter fout) throws IOException {
        fout.println(Integer.toString(this.features.size()));
        for (int i = 0; i < this.features.size(); ++i) {
            Feature f = (Feature)this.features.get(i);
            fout.println(f.toString(this.data.cpInt2Str, this.data.lbInt2Str));
        }
        fout.println(Option.modelSeparator);
    }

    public void scanReset() {
        this.currentFeatureIdx = 0;
    }

    public void startScanFeatures(Observation obsr) {
        this.currentFeatures.clear();
        this.currentFeatureIdx = 0;
        for (int i = 0; i < obsr.cps.length; ++i) {
            Element elem = (Element)this.dict.dict.get(new Integer(obsr.cps[i]));
            if (elem == null) continue;
            if (!elem.isScanned) {
                for (Integer labelInt : elem.lbCntFidxes.keySet()) {
                    CountFIdx cntFIdx = (CountFIdx)elem.lbCntFidxes.get(labelInt);
                    if (cntFIdx.fidx < 0) continue;
                    Feature f = new Feature();
                    f.FeatureInit(labelInt, obsr.cps[i]);
                    f.idx = cntFIdx.fidx;
                    elem.cpFeatures.add(f);
                }
                elem.isScanned = true;
            }
            for (int j = 0; j < elem.cpFeatures.size(); ++j) {
                this.currentFeatures.add(elem.cpFeatures.get(j));
            }
        }
    }

    public boolean hasNextFeature() {
        return this.currentFeatureIdx < this.currentFeatures.size();
    }

    public Feature nextFeature() {
        Feature f = (Feature)this.currentFeatures.get(this.currentFeatureIdx);
        ++this.currentFeatureIdx;
        return f;
    }
}

