/*
 * Decompiled with CFR 0.152.
 */
package jflexcrf;

import java.util.List;
import jflexcrf.DoubleMatrix;
import jflexcrf.DoubleVector;
import jflexcrf.Feature;
import jflexcrf.Model;
import jflexcrf.Observation;

public class Viterbi {
    public Model model = null;
    int numLabels = 0;
    DoubleMatrix Mi = null;
    DoubleVector Vi = null;
    public int memorySize = 0;
    public PairDblInt[][] memory = null;

    public void init(Model model) {
        this.model = model;
        this.numLabels = model.taggerMaps.numLabels();
        this.Mi = new DoubleMatrix(this.numLabels, this.numLabels);
        this.Vi = new DoubleVector(this.numLabels);
        this.allocateMemory(100);
        this.computeMi();
    }

    public void allocateMemory(int memorySize) {
        this.memorySize = memorySize;
        this.memory = new PairDblInt[memorySize][this.numLabels];
        for (int i = 0; i < memorySize; ++i) {
            for (int j = 0; j < this.numLabels; ++j) {
                this.memory[i][j] = new PairDblInt();
            }
        }
    }

    public void computeMi() {
        this.Mi.assign(0.0);
        this.model.taggerFGen.startScanEFeatures();
        while (this.model.taggerFGen.hasNextEFeature()) {
            Feature f = this.model.taggerFGen.nextEFeature();
            if (f.ftype != 1) continue;
            double[] dArray = this.Mi.mtrx[f.yp];
            int n = f.y;
            dArray[n] = dArray[n] + this.model.lambda[f.idx] * (double)f.val;
        }
        for (int i = 0; i < this.Mi.rows; ++i) {
            for (int j = 0; j < this.Mi.cols; ++j) {
                this.Mi.mtrx[i][j] = Math.exp(this.Mi.mtrx[i][j]);
            }
        }
    }

    public void computeVi(List seq, int pos, DoubleVector Vi, boolean isExp) {
        Vi.assign(0.0);
        this.model.taggerFGen.startScanSFeaturesAt(seq, pos);
        while (this.model.taggerFGen.hasNextSFeature()) {
            Feature f = this.model.taggerFGen.nextSFeature();
            if (f.ftype != 3) continue;
            int n = f.y;
            Vi.vect[n] = Vi.vect[n] + this.model.lambda[f.idx] * (double)f.val;
        }
        if (isExp) {
            for (int i = 0; i < Vi.len; ++i) {
                Vi.vect[i] = Math.exp(Vi.vect[i]);
            }
        }
    }

    public double sum(PairDblInt[] cols) {
        double res = 0.0;
        for (int i = 0; i < this.numLabels; ++i) {
            res += cols[i].first;
        }
        if (res < 1.0 && res > -1.0) {
            res = 1.0;
        }
        return res;
    }

    public void divide(PairDblInt[] cols, double val) {
        for (int i = 0; i < this.numLabels; ++i) {
            cols[i].first /= val;
        }
    }

    public int findMax(PairDblInt[] cols) {
        int maxIdx = 0;
        double maxVal = -1.0;
        for (int i = 0; i < this.numLabels; ++i) {
            if (!(cols[i].first > maxVal)) continue;
            maxVal = cols[i].first;
            maxIdx = i;
        }
        return maxIdx;
    }

    public void viterbiInference(List seq) {
        int maxIdx;
        int i;
        int j;
        int seqLen = seq.size();
        if (seqLen <= 0) {
            return;
        }
        if (this.memorySize < seqLen) {
            this.allocateMemory(seqLen);
        }
        this.computeVi(seq, 0, this.Vi, true);
        for (j = 0; j < this.numLabels; ++j) {
            this.memory[0][j].first = this.Vi.vect[j];
            this.memory[0][j].second = j;
        }
        this.divide(this.memory[0], this.sum(this.memory[0]));
        for (i = 1; i < seqLen; ++i) {
            this.computeVi(seq, i, this.Vi, true);
            for (j = 0; j < this.numLabels; ++j) {
                this.memory[i][j].first = 0.0;
                this.memory[i][j].second = 0;
                for (int k = 0; k < this.numLabels; ++k) {
                    double tempVal = this.memory[i - 1][k].first * this.Mi.mtrx[k][j] * this.Vi.vect[j];
                    if (!(tempVal > this.memory[i][j].first)) continue;
                    this.memory[i][j].first = tempVal;
                    this.memory[i][j].second = k;
                }
            }
            this.divide(this.memory[i], this.sum(this.memory[i]));
        }
        ((Observation)seq.get((int)(seqLen - 1))).modelLabel = maxIdx = this.findMax(this.memory[seqLen - 1]);
        for (i = seqLen - 2; i >= 0; --i) {
            maxIdx = ((Observation)seq.get((int)i)).modelLabel = this.memory[i + 1][maxIdx].second;
        }
    }

    public class PairDblInt {
        public double first = 0.0;
        public int second = -1;
    }
}

