/*
 * Decompiled with CFR 0.152.
 */
package de.unihd.dbs.uima.reader.tempeval2reader;

import de.unihd.dbs.uima.types.heideltime.Dct;
import de.unihd.dbs.uima.types.heideltime.Sentence;
import de.unihd.dbs.uima.types.heideltime.Token;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;

public class Tempeval2Reader
extends CollectionReader_ImplBase {
    private static Logger logger = null;
    private static final String compontent_id = "de.unihd.dbs.uima.reader.tempeval2reader";
    public static final String FILE_BASE_SEGMENTATION = "base-segmentation.tab";
    public static final String FILE_DCT = "dct.tab";
    public Integer numberOfDocuments = 0;
    public HashMap<String, Token> hmToken = new HashMap();
    public HashMap<String, Dct> hmDct = new HashMap();
    public static final String PARAM_INPUTDIR = "InputDirectory";
    public static final String PARAM_CHARSET = "Charset";
    public static final String PARAM_USE_SPACES = "UseSpacesAsSeparators";
    private List<String> filenames = new ArrayList<String>();
    private int currentIndex;
    Boolean resettingParentheses = true;
    int newTokSentNumber = 0;
    Charset charset = null;
    Boolean USE_SPACES = true;

    public void initialize() throws ResourceInitializationException {
        String charsetText = (String)this.getConfigParameterValue(PARAM_CHARSET);
        if (charsetText == null || charsetText.equals("")) {
            charsetText = "UTF-8";
        }
        try {
            this.charset = Charset.forName(charsetText);
        }
        catch (Exception e) {
            System.err.println("[de.unihd.dbs.uima.reader.tempeval2reader] Charset " + charsetText + " was not available to be used.");
            throw new ResourceInitializationException();
        }
        Boolean useSpaces = (Boolean)this.getConfigParameterValue(PARAM_USE_SPACES);
        this.USE_SPACES = useSpaces != false ? Boolean.valueOf(true) : Boolean.valueOf(false);
        List<File> inputFiles = this.getFilesFromInputDirectory();
        this.numberOfDocuments = this.getNumberOfDocuments(inputFiles);
        System.err.println("[de.unihd.dbs.uima.reader.tempeval2reader] number of documents: " + this.numberOfDocuments);
    }

    public void getNext(CAS cas) throws IOException, CollectionException {
        JCas jcas;
        try {
            jcas = cas.getJCas();
        }
        catch (CASException e) {
            throw new CollectionException((Throwable)e);
        }
        this.hmToken.clear();
        this.hmDct.clear();
        String docname = this.filenames.get(this.currentIndex++);
        List<File> inputFiles = this.getFilesFromInputDirectory();
        this.setTextSentencesTokens(docname, inputFiles, jcas);
        this.setDocumentCreationTime(docname, inputFiles, jcas);
    }

    public boolean hasNext() throws IOException, CollectionException {
        return this.currentIndex < this.numberOfDocuments;
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.currentIndex, this.numberOfDocuments.intValue(), "entities")};
    }

    public void close() throws IOException {
    }

    public void setDocumentCreationTime(String docname, List<File> inputFiles, JCas jcas) throws IOException {
        String documentCreationTime = "";
        String directory = (String)this.getConfigParameterValue(PARAM_INPUTDIR);
        String filename = directory + "/" + FILE_DCT;
        for (File file : inputFiles) {
            if (!file.getAbsolutePath().equals(filename)) continue;
            try {
                String line;
                BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.charset));
                while ((line = bf.readLine()) != null) {
                    String[] parts = line.split("(\t)+");
                    String fileId = parts[0];
                    if (!fileId.equals(docname)) continue;
                    documentCreationTime = parts[1];
                    Dct dct = new Dct(jcas);
                    String text = jcas.getDocumentText();
                    dct.setBegin(0);
                    dct.setEnd(text.length());
                    dct.setFilename(fileId);
                    dct.setValue(documentCreationTime);
                    dct.setTimexId("t0");
                    dct.addToIndexes();
                    this.hmDct.put("t0", dct);
                }
                bf.close();
            }
            catch (IOException e) {
                throw new IOException(e);
            }
        }
    }

    public void setTextSentencesTokens(String docname, List<File> inputFiles, JCas jcas) throws IOException {
        String text = "";
        String sentString = "";
        Integer positionCounter = 0;
        Integer sentId = -1;
        Integer lastSentId = -1;
        String directory = (String)this.getConfigParameterValue(PARAM_INPUTDIR);
        String filename = directory + "/" + FILE_BASE_SEGMENTATION;
        for (File file : inputFiles) {
            if (!file.getAbsolutePath().equals(filename)) continue;
            try {
                String line;
                BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.charset));
                Boolean lastSentProcessed = false;
                Boolean firstSentProcessed = false;
                String fileId = "";
                Boolean veryFirstLine = true;
                while ((line = bf.readLine()) != null) {
                    String[] parts;
                    if (veryFirstLine.booleanValue()) {
                        parts = line.split("\t");
                        this.newTokSentNumber = Integer.parseInt(parts[1]);
                    }
                    veryFirstLine = false;
                    parts = line.split("\t");
                    fileId = parts[0];
                    sentId = Integer.parseInt(parts[1]);
                    Integer tokId = Integer.parseInt(parts[2]);
                    String tokenString = "";
                    if (parts.length >= 4) {
                        tokenString = parts[3];
                    }
                    if (this.resettingParentheses.booleanValue()) {
                        tokenString = this.resetParentheses(tokenString);
                    }
                    if (fileId.equals(docname)) {
                        if (sentId == this.newTokSentNumber && tokId == this.newTokSentNumber) {
                            firstSentProcessed = true;
                            text = tokenString;
                            sentString = tokenString;
                            positionCounter = this.addTokenAnnotation(tokenString, fileId, sentId, tokId, positionCounter, jcas);
                        } else if (tokId == this.newTokSentNumber || lastSentId != sentId) {
                            positionCounter = this.addSentenceAnnotation(sentString, fileId, sentId - 1, positionCounter, jcas);
                            text = this.USE_SPACES == false ? text + tokenString : text + " " + tokenString;
                            sentString = tokenString;
                            positionCounter = this.addTokenAnnotation(tokenString, fileId, sentId, tokId, positionCounter, jcas);
                        } else {
                            if (!this.USE_SPACES.booleanValue()) {
                                text = text + tokenString;
                                sentString = sentString + tokenString;
                            } else {
                                text = text + " " + tokenString;
                                sentString = sentString + " " + tokenString;
                            }
                            positionCounter = this.addTokenAnnotation(tokenString, fileId, sentId, tokId, positionCounter, jcas);
                        }
                    } else if (firstSentProcessed.booleanValue() && !lastSentProcessed.booleanValue()) {
                        positionCounter = this.addSentenceAnnotation(sentString, docname, lastSentId, positionCounter, jcas);
                        lastSentProcessed = true;
                    }
                    lastSentId = sentId;
                }
                if (fileId.equals(docname)) {
                    positionCounter = this.addSentenceAnnotation(sentString, docname, lastSentId, positionCounter, jcas);
                }
                bf.close();
            }
            catch (IOException e) {
                throw new IOException(e);
            }
        }
        jcas.setDocumentText(text);
    }

    public String resetParentheses(String tokenString) {
        if (tokenString.equals("-LRB-")) {
            tokenString = tokenString.replace("-LRB-", "(");
        } else if (tokenString.equals("-RRB-")) {
            tokenString = tokenString.replace("-RRB-", ")");
        } else if (tokenString.equals("-LSB-")) {
            tokenString = tokenString.replace("-LSB-", "[");
        } else if (tokenString.equals("-RSB-")) {
            tokenString = tokenString.replace("-RSB-", "]");
        } else if (tokenString.equals("-LCB-")) {
            tokenString = tokenString.replace("-LCB-", "{");
        } else if (tokenString.equals("-RCB-")) {
            tokenString = tokenString.replace("-RCB-", "}");
        } else if (tokenString.endsWith("a'")) {
            tokenString = tokenString.replaceFirst("a'", "\u00e0");
        } else if (tokenString.endsWith("i'")) {
            tokenString = tokenString.replaceFirst("i'", "\u00ec");
        } else if (tokenString.endsWith("e'")) {
            tokenString = tokenString.replaceFirst("e'", "\u00e8");
        } else if (tokenString.endsWith("u'")) {
            tokenString = tokenString.replaceFirst("u'", "\u00f9");
        } else if (tokenString.endsWith("o'")) {
            tokenString = tokenString.replaceFirst("o'", "\u00f2");
        }
        return tokenString;
    }

    public Integer addSentenceAnnotation(String sentenceString, String fileId, Integer sentId, Integer positionCounter, JCas jcas) {
        Sentence sentence = new Sentence(jcas);
        Integer begin = positionCounter - sentenceString.length();
        sentence.setFilename(fileId);
        sentence.setSentenceId(sentId);
        sentence.setBegin(begin);
        sentence.setEnd(positionCounter);
        sentence.addToIndexes();
        return positionCounter;
    }

    public Integer addTokenAnnotation(String tokenString, String fileId, Integer sentId, Integer tokId, Integer positionCounter, JCas jcas) {
        Token token = new Token(jcas);
        if ((sentId != this.newTokSentNumber || tokId != this.newTokSentNumber) && this.USE_SPACES.booleanValue()) {
            positionCounter = positionCounter + 1;
        }
        token.setBegin(positionCounter);
        positionCounter = positionCounter + tokenString.length();
        token.setEnd(positionCounter);
        token.setTokenId(tokId);
        token.setSentId(sentId);
        token.setFilename(fileId);
        token.addToIndexes();
        String id = fileId + "_" + sentId + "_" + tokId;
        this.hmToken.put(id, token);
        return positionCounter;
    }

    private Integer getNumberOfDocuments(List<File> inputFiles) throws ResourceInitializationException {
        String directory = (String)this.getConfigParameterValue(PARAM_INPUTDIR);
        String filename = directory + "/" + FILE_BASE_SEGMENTATION;
        for (File file : inputFiles) {
            if (!file.getAbsolutePath().equals(filename)) continue;
            try {
                String line;
                BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.charset));
                while ((line = bf.readLine()) != null) {
                    String docName = line.split("\t")[0];
                    if (this.filenames.contains(docName)) continue;
                    this.filenames.add(docName);
                }
                bf.close();
            }
            catch (IOException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
        }
        int docCounter = this.filenames.size();
        return docCounter;
    }

    private List<File> getFilesFromInputDirectory() {
        File directory = new File(((String)this.getConfigParameterValue(PARAM_INPUTDIR)).trim());
        ArrayList<File> documentFiles = new ArrayList<File>();
        if (!directory.exists() || !directory.isDirectory()) {
            logger.log(Level.WARNING, "getFilesFromInputDirectory() " + directory + " does not exist. Client has to set configuration parameter '" + PARAM_INPUTDIR + "'.");
            return null;
        }
        File[] dirFiles = directory.listFiles();
        for (int i = 0; i < dirFiles.length; ++i) {
            if (dirFiles[i].isDirectory()) continue;
            documentFiles.add(dirFiles[i]);
        }
        return documentFiles;
    }
}

