/*
 * Decompiled with CFR 0.152.
 */
package de.unihd.dbs.uima.annotator.treetagger;

import de.unihd.dbs.uima.types.heideltime.Sentence;
import de.unihd.dbs.uima.types.heideltime.Token;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.uima.jcas.JCas;

public class TreeTaggerReader
implements Runnable {
    private List<Token> tokens;
    private BufferedReader reader;
    private JCas jcas;
    private Boolean annotate_sentences;
    private int i;
    private static final HashSet<String> hsEndOfSentenceTag = new HashSet<String>(Arrays.asList("SENT", "$.", "FS", "_Z_Fst", "_Z_Int", "_Z_Exc", "ew"));

    public TreeTaggerReader(List<Token> tokens, BufferedReader reader, JCas jcas, Boolean annotate_sentences) {
        this.tokens = tokens;
        this.reader = reader;
        this.jcas = jcas;
        this.annotate_sentences = annotate_sentences;
    }

    @Override
    public void run() {
        this.i = 0;
        try {
            Boolean isStarted = false;
            Sentence sentence = null;
            String s = null;
            while (null != (s = this.reader.readLine()) && !isStarted.booleanValue()) {
                if (!"<This-is-the-start-of-the-text />".equals(s)) continue;
                isStarted = true;
                break;
            }
            while (null != (s = this.reader.readLine()) && isStarted.booleanValue()) {
                if ("<This-is-the-end-of-the-text />".equals(s)) {
                    isStarted = false;
                    break;
                }
                String[] splits = s.split("\t", 2);
                String tokenStr = splits[0].trim();
                String pos = "";
                if (splits.length == 2) {
                    pos = splits[1].trim();
                }
                Token token = this.tokens.get(this.i++);
                while ("".equals(token.getCoveredText())) {
                    if ("EMPTYLINE".equals(token.getPos()) && this.annotate_sentences.booleanValue()) {
                        if (sentence == null) {
                            sentence = new Sentence(this.jcas);
                            sentence.setBegin(token.getBegin());
                        }
                        sentence.setEnd(token.getEnd());
                        if (sentence.getBegin() < sentence.getEnd()) {
                            sentence.addToIndexes();
                        }
                        sentence = null;
                    }
                    token.removeFromIndexes();
                    token = this.tokens.get(this.i++);
                }
                token.removeFromIndexes();
                if (!"".equals(token.getCoveredText())) {
                    token.setPos(pos);
                    token.addToIndexes();
                }
                if (!this.annotate_sentences.booleanValue()) continue;
                if (sentence == null) {
                    sentence = new Sentence(this.jcas);
                    sentence.setBegin(token.getBegin());
                }
                if (!hsEndOfSentenceTag.contains(pos) && this.i != this.tokens.size()) continue;
                sentence.setEnd(token.getEnd());
                sentence.addToIndexes();
                sentence = null;
            }
            while (this.i < this.tokens.size()) {
                Token currentToken = this.tokens.get(this.i++);
                if (sentence != null) {
                    sentence.setEnd(this.tokens.get(this.tokens.size() - 1).getEnd());
                    sentence.addToIndexes();
                }
                if (!"EMPTYLINE".equals(currentToken.getPos())) continue;
                currentToken.removeFromIndexes();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

