/*
 * Decompiled with CFR 0.152.
 */
package de.unihd.dbs.uima.annotator.treetagger;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class TreeTaggerProperties {
    public static final String FLUSH_SEQUENCE = "\n.\n.\n.\n.\n.\n(\n)\n.\n.\n.\n.\n";
    public static final String STARTOFTEXT = "<This-is-the-start-of-the-text />";
    public static final String ENDOFTEXT = "<This-is-the-end-of-the-text />";
    public String languageName = null;
    public String rootPath = null;
    public String tokScriptName = null;
    public String parFileName = null;
    public String abbFileName = null;
    public String languageSwitch = null;
    public String utf8Switch = "-CSD";
    public String newLineSeparator = System.getProperty("line.separator");
    public String fileSeparator = System.getProperty("file.separator");
    public File chineseTokenizerPath = null;

    @Deprecated
    public Process getTokenizationProcess(File inputFile) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add("perl");
        if (this.utf8Switch != "") {
            command.add(this.utf8Switch);
        }
        command.add(this.rootPath + this.fileSeparator + "cmd" + this.fileSeparator + this.tokScriptName);
        if (this.languageSwitch != "") {
            command.add(this.languageSwitch);
        }
        if (new File(this.rootPath + this.fileSeparator + "lib" + this.fileSeparator, this.abbFileName).exists()) {
            command.add("-a");
            command.add(this.rootPath + this.fileSeparator + "lib" + this.fileSeparator + this.abbFileName);
        }
        command.add(inputFile.getAbsolutePath());
        String[] commandStr = new String[command.size()];
        command.toArray(commandStr);
        Process p = Runtime.getRuntime().exec(commandStr);
        return p;
    }

    public Process getChineseTokenizationProcess() throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(new File(this.chineseTokenizerPath, "segment-zh.pl"))));
        String segmenterScript = "";
        String buf = null;
        Boolean firstLine = true;
        while ((buf = br.readLine()) != null) {
            if (buf.startsWith("#")) continue;
            if (buf.startsWith("$lexicon=")) {
                buf = "$lexicon=\"" + new File(this.chineseTokenizerPath, "lcmc-uni2.dat").getAbsolutePath().replaceAll("\\\\", "/") + "\";";
            }
            if (buf.startsWith("$lexicon2=")) {
                buf = "$lexicon2=\"" + new File(this.chineseTokenizerPath, "lcmc-bigrams2.dat").getAbsolutePath().replaceAll("\\\\", "/") + "\";";
            }
            buf = buf.replaceAll("\"", "'");
            buf = buf.replaceAll("'\\\\n'", "chr(10)");
            if (firstLine.booleanValue()) {
                segmenterScript = segmenterScript + "$| = 1;";
                firstLine = false;
            }
            segmenterScript = segmenterScript + buf;
        }
        br.close();
        command.add("perl");
        command.add("-X");
        command.add("-e");
        command.add(segmenterScript);
        String[] commandStr = new String[command.size()];
        command.toArray(commandStr);
        ProcessBuilder builder = new ProcessBuilder(commandStr);
        builder.directory(this.chineseTokenizerPath);
        return builder.start();
    }

    public Process getTreeTaggingProcess(File inputFile) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.rootPath + this.fileSeparator + "bin" + this.fileSeparator + "tree-tagger");
        command.add(this.rootPath + this.fileSeparator + "lib" + this.fileSeparator + this.parFileName);
        command.add(inputFile.getAbsolutePath());
        command.add("-no-unknown");
        String[] commandStr = new String[command.size()];
        command.toArray(commandStr);
        return Runtime.getRuntime().exec(commandStr);
    }

    public Process getTreeTaggingProcess() throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.rootPath + this.fileSeparator + "bin" + this.fileSeparator + "tree-tagger");
        command.add(this.rootPath + this.fileSeparator + "lib" + this.fileSeparator + this.parFileName);
        command.add("-no-unknown");
        command.add("-quiet");
        command.add("-token");
        command.add("-sgml");
        String[] commandStr = new String[command.size()];
        command.toArray(commandStr);
        ProcessBuilder builder = new ProcessBuilder(commandStr);
        builder.redirectErrorStream(true);
        return builder.start();
    }
}

