/*
 * Decompiled with CFR 0.152.
 */
package de.unihd.dbs.uima.annotator.heideltime.resources;

import de.unihd.dbs.uima.annotator.heideltime.resources.GenericResourceManager;
import de.unihd.dbs.uima.annotator.heideltime.resources.Language;
import de.unihd.dbs.uima.annotator.heideltime.resources.RePatternManager;
import de.unihd.dbs.uima.annotator.heideltime.resources.ResourceMap;
import de.unihd.dbs.uima.annotator.heideltime.resources.ResourceScanner;
import de.unihd.dbs.uima.annotator.heideltime.utilities.Logger;
import de.unihd.dbs.uima.annotator.heideltime.utilities.Toolbox;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RuleManager
extends GenericResourceManager {
    protected static HashMap<String, RuleManager> instances = new HashMap();
    Pattern paReadRules = Pattern.compile("RULENAME=\"(.*?)\",EXTRACTION=\"(.*?)\",NORM_VALUE=\"(.*?)\"(.*)");
    HashMap<Pattern, String> hmDatePattern = new HashMap();
    HashMap<Pattern, String> hmDurationPattern = new HashMap();
    HashMap<Pattern, String> hmTimePattern = new HashMap();
    HashMap<Pattern, String> hmSetPattern = new HashMap();
    HashMap<String, String> hmDateNormalization = new HashMap();
    HashMap<String, String> hmTimeNormalization = new HashMap();
    HashMap<String, String> hmDurationNormalization = new HashMap();
    HashMap<String, String> hmSetNormalization = new HashMap();
    HashMap<String, String> hmDateOffset = new HashMap();
    HashMap<String, String> hmTimeOffset = new HashMap();
    HashMap<String, String> hmDurationOffset = new HashMap();
    HashMap<String, String> hmSetOffset = new HashMap();
    HashMap<String, String> hmDateQuant = new HashMap();
    HashMap<String, String> hmTimeQuant = new HashMap();
    HashMap<String, String> hmDurationQuant = new HashMap();
    HashMap<String, String> hmSetQuant = new HashMap();
    HashMap<String, String> hmDateFreq = new HashMap();
    HashMap<String, String> hmTimeFreq = new HashMap();
    HashMap<String, String> hmDurationFreq = new HashMap();
    HashMap<String, String> hmSetFreq = new HashMap();
    HashMap<String, String> hmDateMod = new HashMap();
    HashMap<String, String> hmTimeMod = new HashMap();
    HashMap<String, String> hmDurationMod = new HashMap();
    HashMap<String, String> hmSetMod = new HashMap();
    HashMap<String, String> hmDatePosConstraint = new HashMap();
    HashMap<String, String> hmTimePosConstraint = new HashMap();
    HashMap<String, String> hmDurationPosConstraint = new HashMap();
    HashMap<String, String> hmSetPosConstraint = new HashMap();
    HashMap<String, String> hmDateEmptyValue = new HashMap();
    HashMap<String, String> hmTimeEmptyValue = new HashMap();
    HashMap<String, String> hmDurationEmptyValue = new HashMap();
    HashMap<String, String> hmSetEmptyValue = new HashMap();
    HashMap<String, Pattern> hmDateFastCheck = new HashMap();
    HashMap<String, Pattern> hmTimeFastCheck = new HashMap();
    HashMap<String, Pattern> hmDurationFastCheck = new HashMap();
    HashMap<String, Pattern> hmSetFastCheck = new HashMap();
    HashMap<Pattern, String> hmTemponymPattern = new HashMap();
    HashMap<String, String> hmTemponymNormalization = new HashMap();
    HashMap<String, String> hmTemponymOffset = new HashMap();
    HashMap<String, String> hmTemponymQuant = new HashMap();
    HashMap<String, String> hmTemponymFreq = new HashMap();
    HashMap<String, String> hmTemponymMod = new HashMap();
    HashMap<String, String> hmTemponymPosConstraint = new HashMap();
    HashMap<String, String> hmTemponymEmptyValue = new HashMap();
    HashMap<String, Pattern> hmTemponymFastCheck = new HashMap();

    protected RuleManager(String language, Boolean load_temponym_resources) {
        super("rules", language);
        ResourceScanner rs = ResourceScanner.getInstance();
        ResourceMap hmResourcesRules = rs.getRules(language);
        this.readRules(hmResourcesRules, language, load_temponym_resources);
    }

    public static RuleManager getInstance(Language language, Boolean load_temponym_resources) {
        if (!instances.containsKey(language.getName())) {
            RuleManager nm = new RuleManager(language.getResourceFolder(), load_temponym_resources);
            instances.put(language.getName(), nm);
        }
        return instances.get(language.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readRules(ResourceMap hmResourcesRules, String language, Boolean load_temponym_resources) {
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        LinkedList<String> resourceKeys = new LinkedList<String>(hmResourcesRules.keySet());
        Collections.sort(resourceKeys, new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                if ("daterules".equals(arg0)) {
                    return -1;
                }
                if ("timerules".equals(arg0) && !"daterules".equals(arg1)) {
                    return -1;
                }
                if ("durationrules".equals(arg0) && !"daterules".equals(arg1) && !"timerules".equals(arg1)) {
                    return -1;
                }
                if ("setrules".equals(arg0) && !"daterules".equals(arg1) && !"timerules".equals(arg1) && !"durationrules".equals(arg1)) {
                    return -1;
                }
                return 1;
            }
        });
        try {
            for (String resource : resourceKeys) {
                String line;
                is = hmResourcesRules.getInputStream(resource);
                isr = new InputStreamReader(is, "UTF-8");
                br = new BufferedReader(isr);
                Logger.printDetail(this.component, "Adding rule resource: " + resource);
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("//") || line.equals("")) continue;
                    boolean correctLine = false;
                    Logger.printDetail("DEBUGGING: reading rules..." + line);
                    for (MatchResult r : Toolbox.findMatches(this.paReadRules, line)) {
                        correctLine = true;
                        String rule_name = r.group(1);
                        String rule_extraction = this.replaceSpaces(r.group(2));
                        String rule_normalization = r.group(3);
                        String rule_offset = "";
                        String rule_quant = "";
                        String rule_freq = "";
                        String rule_mod = "";
                        String pos_constraint = "";
                        String rule_empty_value = "";
                        String rule_fast_check = "";
                        if (this.hmDatePattern.containsValue(rule_name) || this.hmDurationPattern.containsValue(rule_name) || this.hmSetPattern.containsValue(rule_name) || this.hmTimePattern.containsValue(rule_name)) {
                            Logger.printError("WARNING: Duplicate rule name detected. This rule is being ignored:");
                            Logger.printError(line);
                        }
                        Pattern paVariable = Pattern.compile("%(re[a-zA-Z0-9]*)");
                        RePatternManager rpm = RePatternManager.getInstance(Language.getLanguageFromString(language), load_temponym_resources);
                        for (MatchResult mr : Toolbox.findMatches(paVariable, rule_extraction)) {
                            Logger.printDetail("DEBUGGING: replacing patterns..." + mr.group());
                            if (!rpm.containsKey(mr.group(1)).booleanValue()) {
                                Logger.printError("Error creating rule:" + rule_name);
                                Logger.printError("The following pattern used in this rule does not exist, does it? %" + mr.group(1));
                                System.exit(-1);
                            }
                            rule_extraction = rule_extraction.replaceAll("%" + mr.group(1), rpm.get(mr.group(1)));
                        }
                        rule_extraction = rule_extraction.replaceAll(" ", "[\\\\s]+");
                        Pattern pattern = null;
                        try {
                            pattern = Pattern.compile(rule_extraction);
                        }
                        catch (PatternSyntaxException e) {
                            Logger.printError("Compiling rules resulted in errors.");
                            Logger.printError("Problematic rule is " + rule_name);
                            Logger.printError("Cannot compile pattern: " + rule_extraction);
                            e.printStackTrace();
                            System.exit(-1);
                        }
                        Pattern patternFast = null;
                        if (r.group(4) != null) {
                            if (r.group(4).contains("OFFSET")) {
                                Pattern paOffset = Pattern.compile("OFFSET=\"(.*?)\"");
                                for (MatchResult ro : Toolbox.findMatches(paOffset, line)) {
                                    rule_offset = ro.group(1);
                                }
                            }
                            if (r.group(4).contains("NORM_QUANT")) {
                                Pattern paQuant = Pattern.compile("NORM_QUANT=\"(.*?)\"");
                                for (MatchResult rq : Toolbox.findMatches(paQuant, line)) {
                                    rule_quant = rq.group(1);
                                }
                            }
                            if (r.group(4).contains("NORM_FREQ")) {
                                Pattern paFreq = Pattern.compile("NORM_FREQ=\"(.*?)\"");
                                for (MatchResult rf : Toolbox.findMatches(paFreq, line)) {
                                    rule_freq = rf.group(1);
                                }
                            }
                            if (r.group(4).contains("NORM_MOD")) {
                                Pattern paMod = Pattern.compile("NORM_MOD=\"(.*?)\"");
                                for (MatchResult rf : Toolbox.findMatches(paMod, line)) {
                                    rule_mod = rf.group(1);
                                }
                            }
                            if (r.group(4).contains("POS_CONSTRAINT")) {
                                Pattern paPos = Pattern.compile("POS_CONSTRAINT=\"(.*?)\"");
                                for (MatchResult rp : Toolbox.findMatches(paPos, line)) {
                                    pos_constraint = rp.group(1);
                                }
                            }
                            if (r.group(4).contains("EMPTY_VALUE")) {
                                Pattern paEmpty = Pattern.compile("EMPTY_VALUE=\"(.*?)\"");
                                for (MatchResult rp : Toolbox.findMatches(paEmpty, line)) {
                                    rule_empty_value = rp.group(1);
                                }
                            }
                            if (r.group(4).contains("FAST_CHECK")) {
                                Pattern paFast = Pattern.compile("FAST_CHECK=\"(.*?)\"");
                                for (MatchResult rp : Toolbox.findMatches(paFast, line)) {
                                    rule_fast_check = rp.group(1);
                                    for (MatchResult mr : Toolbox.findMatches(paVariable, rule_fast_check)) {
                                        Logger.printDetail("DEBUGGING: replacing patterns..." + mr.group());
                                        if (!rpm.containsKey(mr.group(1)).booleanValue()) {
                                            Logger.printError("Error creating rule:" + rule_name);
                                            Logger.printError("The following pattern used in this rule does not exist, does it? %" + mr.group(1));
                                            System.exit(-1);
                                        }
                                        rule_fast_check = rule_fast_check.replaceAll("%" + mr.group(1), rpm.get(mr.group(1)));
                                    }
                                    rule_fast_check = rule_fast_check.replaceAll(" ", "[\\\\s]+");
                                    patternFast = null;
                                    try {
                                        patternFast = Pattern.compile(rule_fast_check);
                                    }
                                    catch (PatternSyntaxException e) {
                                        Logger.printError("Compiling rules resulted in errors.");
                                        Logger.printError("Problematic rule is " + rule_name);
                                        Logger.printError("Cannot compile pattern: " + rule_fast_check);
                                        e.printStackTrace();
                                        System.exit(-1);
                                    }
                                }
                            }
                        }
                        if (resource.equals("daterules")) {
                            this.hmDatePattern.put(pattern, rule_name);
                            this.hmDateNormalization.put(rule_name, rule_normalization);
                            if (!rule_offset.equals("")) {
                                this.hmDateOffset.put(rule_name, rule_offset);
                            }
                            if (!rule_quant.equals("")) {
                                this.hmDateQuant.put(rule_name, rule_quant);
                            }
                            if (!rule_freq.equals("")) {
                                this.hmDateFreq.put(rule_name, rule_freq);
                            }
                            if (!rule_mod.equals("")) {
                                this.hmDateMod.put(rule_name, rule_mod);
                            }
                            if (!pos_constraint.equals("")) {
                                this.hmDatePosConstraint.put(rule_name, pos_constraint);
                            }
                            if (!rule_empty_value.equals("")) {
                                this.hmDateEmptyValue.put(rule_name, rule_empty_value);
                            }
                            if (rule_fast_check.equals("")) continue;
                            this.hmDateFastCheck.put(rule_name, patternFast);
                            continue;
                        }
                        if (resource.equals("durationrules")) {
                            this.hmDurationPattern.put(pattern, rule_name);
                            this.hmDurationNormalization.put(rule_name, rule_normalization);
                            if (!rule_offset.equals("")) {
                                this.hmDurationOffset.put(rule_name, rule_offset);
                            }
                            if (!rule_quant.equals("")) {
                                this.hmDurationQuant.put(rule_name, rule_quant);
                            }
                            if (!rule_freq.equals("")) {
                                this.hmDurationFreq.put(rule_name, rule_freq);
                            }
                            if (!rule_mod.equals("")) {
                                this.hmDurationMod.put(rule_name, rule_mod);
                            }
                            if (!pos_constraint.equals("")) {
                                this.hmDurationPosConstraint.put(rule_name, pos_constraint);
                            }
                            if (!rule_empty_value.equals("")) {
                                this.hmDurationEmptyValue.put(rule_name, rule_empty_value);
                            }
                            if (rule_fast_check.equals("")) continue;
                            this.hmDurationFastCheck.put(rule_name, patternFast);
                            continue;
                        }
                        if (resource.equals("setrules")) {
                            this.hmSetPattern.put(pattern, rule_name);
                            this.hmSetNormalization.put(rule_name, rule_normalization);
                            if (!rule_offset.equals("")) {
                                this.hmSetOffset.put(rule_name, rule_offset);
                            }
                            if (!rule_quant.equals("")) {
                                this.hmSetQuant.put(rule_name, rule_quant);
                            }
                            if (!rule_freq.equals("")) {
                                this.hmSetFreq.put(rule_name, rule_freq);
                            }
                            if (!rule_mod.equals("")) {
                                this.hmSetMod.put(rule_name, rule_mod);
                            }
                            if (!pos_constraint.equals("")) {
                                this.hmSetPosConstraint.put(rule_name, pos_constraint);
                            }
                            if (!rule_empty_value.equals("")) {
                                this.hmSetEmptyValue.put(rule_name, rule_empty_value);
                            }
                            if (rule_fast_check.equals("")) continue;
                            this.hmSetFastCheck.put(rule_name, patternFast);
                            continue;
                        }
                        if (resource.equals("timerules")) {
                            this.hmTimePattern.put(pattern, rule_name);
                            this.hmTimeNormalization.put(rule_name, rule_normalization);
                            if (!rule_offset.equals("")) {
                                this.hmTimeOffset.put(rule_name, rule_offset);
                            }
                            if (!rule_quant.equals("")) {
                                this.hmTimeQuant.put(rule_name, rule_quant);
                            }
                            if (!rule_freq.equals("")) {
                                this.hmTimeFreq.put(rule_name, rule_freq);
                            }
                            if (!rule_mod.equals("")) {
                                this.hmTimeMod.put(rule_name, rule_mod);
                            }
                            if (!pos_constraint.equals("")) {
                                this.hmTimePosConstraint.put(rule_name, pos_constraint);
                            }
                            if (!rule_empty_value.equals("")) {
                                this.hmTimeEmptyValue.put(rule_name, rule_empty_value);
                            }
                            if (rule_fast_check.equals("")) continue;
                            this.hmTimeFastCheck.put(rule_name, patternFast);
                            continue;
                        }
                        if (resource.equals("temponymrules")) {
                            this.hmTemponymPattern.put(pattern, rule_name);
                            this.hmTemponymNormalization.put(rule_name, rule_normalization);
                            if (!rule_offset.equals("")) {
                                this.hmTemponymOffset.put(rule_name, rule_offset);
                            }
                            if (!rule_quant.equals("")) {
                                this.hmTemponymQuant.put(rule_name, rule_quant);
                            }
                            if (!rule_freq.equals("")) {
                                this.hmTemponymFreq.put(rule_name, rule_freq);
                            }
                            if (!rule_mod.equals("")) {
                                this.hmTemponymMod.put(rule_name, rule_mod);
                            }
                            if (!pos_constraint.equals("")) {
                                this.hmTemponymPosConstraint.put(rule_name, pos_constraint);
                            }
                            if (!rule_empty_value.equals("")) {
                                this.hmTemponymEmptyValue.put(rule_name, rule_empty_value);
                            }
                            if (rule_fast_check.equals("")) continue;
                            this.hmTemponymFastCheck.put(rule_name, patternFast);
                            continue;
                        }
                        Logger.printDetail(this.component, "Resource not recognized by HeidelTime: " + resource);
                    }
                    if (correctLine) continue;
                    Logger.printError(this.component, "Cannot read the following line of rule resource " + resource);
                    Logger.printError(this.component, "Line: " + line);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (isr != null) {
                    isr.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public final HashMap<Pattern, String> getHmDatePattern() {
        return this.hmDatePattern;
    }

    public final HashMap<Pattern, String> getHmDurationPattern() {
        return this.hmDurationPattern;
    }

    public final HashMap<Pattern, String> getHmTimePattern() {
        return this.hmTimePattern;
    }

    public final HashMap<Pattern, String> getHmSetPattern() {
        return this.hmSetPattern;
    }

    public final HashMap<String, String> getHmDateNormalization() {
        return this.hmDateNormalization;
    }

    public final HashMap<String, String> getHmTimeNormalization() {
        return this.hmTimeNormalization;
    }

    public final HashMap<String, String> getHmDurationNormalization() {
        return this.hmDurationNormalization;
    }

    public final HashMap<String, String> getHmSetNormalization() {
        return this.hmSetNormalization;
    }

    public final HashMap<String, String> getHmDateOffset() {
        return this.hmDateOffset;
    }

    public final HashMap<String, String> getHmTimeOffset() {
        return this.hmTimeOffset;
    }

    public final HashMap<String, String> getHmDurationOffset() {
        return this.hmDurationOffset;
    }

    public final HashMap<String, String> getHmSetOffset() {
        return this.hmSetOffset;
    }

    public final HashMap<String, String> getHmDateQuant() {
        return this.hmDateQuant;
    }

    public final HashMap<String, String> getHmTimeQuant() {
        return this.hmTimeQuant;
    }

    public final HashMap<String, String> getHmDurationQuant() {
        return this.hmDurationQuant;
    }

    public final HashMap<String, String> getHmSetQuant() {
        return this.hmSetQuant;
    }

    public final HashMap<String, String> getHmDateFreq() {
        return this.hmDateFreq;
    }

    public final HashMap<String, String> getHmTimeFreq() {
        return this.hmTimeFreq;
    }

    public final HashMap<String, String> getHmDurationFreq() {
        return this.hmDurationFreq;
    }

    public final HashMap<String, String> getHmSetFreq() {
        return this.hmSetFreq;
    }

    public final HashMap<String, String> getHmDateMod() {
        return this.hmDateMod;
    }

    public final HashMap<String, String> getHmTimeMod() {
        return this.hmTimeMod;
    }

    public final HashMap<String, String> getHmDurationMod() {
        return this.hmDurationMod;
    }

    public final HashMap<String, String> getHmSetMod() {
        return this.hmSetMod;
    }

    public final HashMap<String, String> getHmDatePosConstraint() {
        return this.hmDatePosConstraint;
    }

    public final HashMap<String, String> getHmTimePosConstraint() {
        return this.hmTimePosConstraint;
    }

    public final HashMap<String, String> getHmDurationPosConstraint() {
        return this.hmDurationPosConstraint;
    }

    public final HashMap<String, String> getHmSetPosConstraint() {
        return this.hmSetPosConstraint;
    }

    public final HashMap<String, String> getHmDateEmptyValue() {
        return this.hmDateEmptyValue;
    }

    public final HashMap<String, String> getHmTimeEmptyValue() {
        return this.hmTimeEmptyValue;
    }

    public final HashMap<String, String> getHmDurationEmptyValue() {
        return this.hmDurationEmptyValue;
    }

    public final HashMap<String, String> getHmSetEmptyValue() {
        return this.hmSetEmptyValue;
    }

    public final HashMap<Pattern, String> getHmTemponymPattern() {
        return this.hmTemponymPattern;
    }

    public final HashMap<String, String> getHmTemponymNormalization() {
        return this.hmTemponymNormalization;
    }

    public final HashMap<String, String> getHmTemponymOffset() {
        return this.hmTemponymOffset;
    }

    public final HashMap<String, String> getHmTemponymQuant() {
        return this.hmTemponymQuant;
    }

    public final HashMap<String, String> getHmTemponymFreq() {
        return this.hmTemponymFreq;
    }

    public final HashMap<String, String> getHmTemponymMod() {
        return this.hmTemponymMod;
    }

    public final HashMap<String, String> getHmTemponymPosConstraint() {
        return this.hmTemponymPosConstraint;
    }

    public final HashMap<String, String> getHmTemponymEmptyValue() {
        return this.hmTemponymEmptyValue;
    }

    public final HashMap<String, Pattern> getHmDateFastCheck() {
        return this.hmDateFastCheck;
    }

    public final HashMap<String, Pattern> getHmTimeFastCheck() {
        return this.hmTimeFastCheck;
    }

    public final HashMap<String, Pattern> getHmDurationFastCheck() {
        return this.hmDurationFastCheck;
    }

    public final HashMap<String, Pattern> getHmSetFastCheck() {
        return this.hmSetFastCheck;
    }

    public final HashMap<String, Pattern> getHmTemponymFastCheck() {
        return this.hmTemponymFastCheck;
    }
}

