/*
 * Decompiled with CFR 0.152.
 */
package de.unihd.dbs.uima.annotator.heideltime.resources;

import de.unihd.dbs.uima.annotator.heideltime.utilities.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ResourceMap
implements Map<String, String> {
    HashMap<String, File> outerFiles = new HashMap();
    HashMap<String, String> innerFiles = new HashMap();

    @Override
    public void clear() {
        this.outerFiles.clear();
        this.innerFiles.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.outerFiles.containsKey(key) || this.innerFiles.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.outerFiles.containsValue(value) || this.innerFiles.containsValue(value);
    }

    @Override
    @Deprecated
    public Set<Map.Entry<String, String>> entrySet() {
        return null;
    }

    @Override
    @Deprecated
    public String get(Object key) {
        return null;
    }

    public InputStream getInputStream(String key) {
        InputStream is = null;
        if (this.outerFiles.containsKey(key)) {
            try {
                is = new FileInputStream(this.outerFiles.get(key));
            }
            catch (FileNotFoundException e) {
                Logger.printError("File " + key + " disppeared while loading resources.");
            }
        } else if (this.innerFiles.containsKey(key)) {
            is = this.getClass().getClassLoader().getResourceAsStream(this.innerFiles.get(key));
        }
        return is;
    }

    @Override
    public boolean isEmpty() {
        return this.outerFiles.isEmpty() && this.innerFiles.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        TreeSet<String> set = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                if (arg0.equals(arg1)) {
                    return 0;
                }
                Integer lengthDiff = arg1.length() - arg0.length();
                return lengthDiff == 0 ? -1 : lengthDiff;
            }
        });
        set.addAll(this.outerFiles.keySet());
        set.addAll(this.innerFiles.keySet());
        return set;
    }

    @Override
    @Deprecated
    public String put(String key, String value) {
        return null;
    }

    public String putInnerFile(String key, String value) {
        return this.innerFiles.put(key, value);
    }

    public File putOuterFile(String key, File value) {
        return this.outerFiles.put(key, value);
    }

    @Override
    @Deprecated
    public void putAll(Map<? extends String, ? extends String> m) {
    }

    @Override
    public String remove(Object key) {
        return null;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Collection<String> values() {
        return null;
    }
}

