/*
 * Decompiled with CFR 0.152.
 */
package de.unihd.dbs.uima.annotator.heideltime.resources;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class RegexHashMap<T>
implements Map<String, T> {
    private HashMap<String, T> container = new HashMap();
    private HashMap<String, T> cache = new HashMap();

    @Override
    public void clear() {
        this.container.clear();
        this.cache.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.cache.containsKey(key)) {
            return true;
        }
        if (this.container.containsKey(key)) {
            return true;
        }
        Iterator<String> regexKeys = this.container.keySet().iterator();
        while (regexKeys.hasNext()) {
            if (!Pattern.matches(regexKeys.next(), (String)key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.cache.containsValue(value)) {
            return true;
        }
        return this.container.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        HashSet<Map.Entry<String, T>> set = new HashSet<Map.Entry<String, T>>();
        set.addAll(this.container.entrySet());
        set.addAll(this.cache.entrySet());
        return set;
    }

    @Override
    public T get(Object key) {
        if (key == null) {
            return null;
        }
        T result = null;
        T t = this.cache.get(key);
        result = t;
        if (t != null) {
            return result;
        }
        T t2 = this.container.get(key);
        result = t2;
        if (t2 != null) {
            return result;
        }
        for (Map.Entry<String, T> entry : this.container.entrySet()) {
            if (!Pattern.matches(entry.getKey(), (String)key)) continue;
            this.putCache((String)key, entry.getValue());
            return entry.getValue();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.container.isEmpty() && this.cache.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this.container.keySet());
        set.addAll(this.cache.keySet());
        return set;
    }

    @Override
    public T put(String key, T value) {
        return this.container.put(key, value);
    }

    public T putCache(String key, T value) {
        return this.cache.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> m) {
        this.container.putAll(m);
    }

    @Override
    public T remove(Object key) {
        return this.container.remove(key);
    }

    @Override
    public int size() {
        return this.container.size() + this.cache.size();
    }

    @Override
    public Collection<T> values() {
        HashSet<T> set = new HashSet<T>();
        set.addAll(this.container.values());
        set.addAll(this.cache.values());
        return set;
    }
}

