/*
 * Decompiled with CFR 0.152.
 */
package de.unihd.dbs.uima.annotator.heideltime.resources;

import de.unihd.dbs.uima.annotator.heideltime.resources.GenericResourceManager;
import de.unihd.dbs.uima.annotator.heideltime.resources.Language;
import de.unihd.dbs.uima.annotator.heideltime.resources.ResourceMap;
import de.unihd.dbs.uima.annotator.heideltime.resources.ResourceScanner;
import de.unihd.dbs.uima.annotator.heideltime.utilities.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.TreeMap;

public class RePatternManager
extends GenericResourceManager {
    protected static HashMap<String, RePatternManager> instances = new HashMap();
    private TreeMap<String, String> hmAllRePattern = new TreeMap();

    private RePatternManager(String language, Boolean load_temponym_resources) {
        super("repattern", language);
        ResourceScanner rs = ResourceScanner.getInstance();
        ResourceMap hmResourcesRePattern = rs.getRepatterns(language);
        for (String which : hmResourcesRePattern.keySet()) {
            this.hmAllRePattern.put(which, "");
        }
        this.readRePatternResources(hmResourcesRePattern, load_temponym_resources);
    }

    public static RePatternManager getInstance(Language language, Boolean load_temponym_resources) {
        if (!instances.containsKey(language.getName())) {
            RePatternManager nm = new RePatternManager(language.getResourceFolder(), load_temponym_resources);
            instances.put(language.getName(), nm);
        }
        return instances.get(language.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRePatternResources(ResourceMap hmResourcesRePattern, Boolean load_temponym_resources) {
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            for (String resource : hmResourcesRePattern.keySet()) {
                if (!resource.contains("Temponym") || load_temponym_resources.booleanValue() && resource.contains("Temponym")) {
                    String line;
                    Logger.printDetail(this.component, "Adding pattern resource: " + resource);
                    is = hmResourcesRePattern.getInputStream(resource);
                    isr = new InputStreamReader(is, "UTF-8");
                    br = new BufferedReader(isr);
                    LinkedList<String> patterns = new LinkedList<String>();
                    while ((line = br.readLine()) != null) {
                        if (line.startsWith("//") || line.equals("")) continue;
                        patterns.add(this.replaceSpaces(line));
                    }
                    Collections.sort(patterns, new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            String o1effective = o1.replaceAll("\\[[^\\]]*\\]", "X").replaceAll("\\?", "").replaceAll("\\\\.(?:\\{([^\\}])+\\})?", "X$1");
                            String o2effective = o2.replaceAll("\\[[^\\]]*\\]", "X").replaceAll("\\?", "").replaceAll("\\\\.(?:\\{([^\\}])+\\})?", "X$1");
                            if (o1effective.length() < o2effective.length()) {
                                return 1;
                            }
                            if (o1effective.length() > o2effective.length()) {
                                return -1;
                            }
                            return 0;
                        }
                    });
                    StringBuilder sb = new StringBuilder();
                    String devPattern = "";
                    for (String pat : patterns) {
                        sb.append("|");
                        sb.append(pat);
                    }
                    devPattern = sb.toString();
                    this.hmAllRePattern.put(resource, devPattern);
                    continue;
                }
                Logger.printDetail(this.component, "No Temponym Tagging selected. Skipping pattern resource: " + resource);
            }
            for (String which : this.hmAllRePattern.keySet()) {
                if (which.contains("Temponym") && (!load_temponym_resources.booleanValue() || !which.contains("Temponym"))) continue;
                this.finalizeRePattern(which, this.hmAllRePattern.get(which));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (isr != null) {
                    isr.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void finalizeRePattern(String name, String rePattern) {
        rePattern = rePattern.replaceFirst("\\|", "");
        rePattern = rePattern.replaceAll("\\(([^\\?])", "(?:$1");
        rePattern = "(" + rePattern + ")";
        rePattern = rePattern.replaceAll("\\\\", "\\\\\\\\");
        this.hmAllRePattern.put(name, rePattern);
    }

    public Boolean containsKey(String key) {
        return this.hmAllRePattern.containsKey(key);
    }

    public String get(String key) {
        return this.hmAllRePattern.get(key);
    }
}

