/*
 * Decompiled with CFR 0.152.
 */
package de.unihd.dbs.uima.annotator.heideltime.resources;

import de.unihd.dbs.uima.annotator.heideltime.resources.GenericResourceManager;
import de.unihd.dbs.uima.annotator.heideltime.resources.Language;
import de.unihd.dbs.uima.annotator.heideltime.resources.RegexHashMap;
import de.unihd.dbs.uima.annotator.heideltime.resources.ResourceMap;
import de.unihd.dbs.uima.annotator.heideltime.resources.ResourceScanner;
import de.unihd.dbs.uima.annotator.heideltime.utilities.Logger;
import de.unihd.dbs.uima.annotator.heideltime.utilities.Toolbox;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public class NormalizationManager
extends GenericResourceManager {
    protected static HashMap<String, NormalizationManager> instances = new HashMap();
    private Pattern paReadNormalizations = Pattern.compile("\"(.*?)\",\"(.*?)\"");
    private HashMap<String, RegexHashMap<String>> hmAllNormalization = new HashMap();
    private HashMap<String, String> normDayInWeek;
    private HashMap<String, String> normNumber = new HashMap();
    private HashMap<String, String> normMonthName;
    private HashMap<String, String> normMonthInSeason;
    private HashMap<String, String> normMonthInQuarter;

    private NormalizationManager(String language, Boolean load_temponym_resources) {
        super("normalization", language);
        this.normDayInWeek = new HashMap();
        this.normMonthName = new HashMap();
        this.normMonthInSeason = new HashMap();
        this.normMonthInQuarter = new HashMap();
        this.readGlobalNormalizationInformation();
        ResourceScanner rs = ResourceScanner.getInstance();
        ResourceMap hmResourcesNormalization = rs.getNormalizations(language);
        for (String which : hmResourcesNormalization.keySet()) {
            this.hmAllNormalization.put(which, new RegexHashMap());
        }
        this.readNormalizationResources(hmResourcesNormalization, load_temponym_resources);
    }

    public static NormalizationManager getInstance(Language language, Boolean load_temponym_resources) {
        if (!instances.containsKey(language.getName())) {
            NormalizationManager nm = new NormalizationManager(language.getResourceFolder(), load_temponym_resources);
            instances.put(language.getName(), nm);
        }
        return instances.get(language.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readNormalizationResources(ResourceMap hmResourcesNormalization, Boolean load_temponym_resources) {
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            for (String resource : hmResourcesNormalization.keySet()) {
                if (!resource.contains("Temponym") || load_temponym_resources.booleanValue() && resource.contains("Temponym")) {
                    String line;
                    Logger.printDetail(this.component, "Adding normalization resource: " + resource);
                    is = hmResourcesNormalization.getInputStream(resource);
                    isr = new InputStreamReader(is, "UTF-8");
                    br = new BufferedReader(isr);
                    while ((line = br.readLine()) != null) {
                        if (line.startsWith("//")) continue;
                        boolean correctLine = false;
                        for (MatchResult r : Toolbox.findMatches(this.paReadNormalizations, line)) {
                            correctLine = true;
                            String resource_word = this.replaceSpaces(r.group(1));
                            String normalized_word = r.group(2);
                            for (String which : this.hmAllNormalization.keySet()) {
                                if (!resource.equals(which)) continue;
                                this.hmAllNormalization.get(which).put(resource_word, normalized_word);
                            }
                            if (correctLine || line.matches("")) continue;
                            Logger.printError("[" + this.component + "] Cannot read one of the lines of normalization resource " + resource);
                            Logger.printError("[" + this.component + "] Line: " + line);
                        }
                    }
                    continue;
                }
                Logger.printDetail(this.component, "No Temponym Tagging selected. Skipping normalization resource: " + resource);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (isr != null) {
                    isr.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void readGlobalNormalizationInformation() {
        this.normMonthInQuarter.put("01", "1");
        this.normMonthInQuarter.put("02", "1");
        this.normMonthInQuarter.put("03", "1");
        this.normMonthInQuarter.put("04", "2");
        this.normMonthInQuarter.put("05", "2");
        this.normMonthInQuarter.put("06", "2");
        this.normMonthInQuarter.put("07", "3");
        this.normMonthInQuarter.put("08", "3");
        this.normMonthInQuarter.put("09", "3");
        this.normMonthInQuarter.put("10", "4");
        this.normMonthInQuarter.put("11", "4");
        this.normMonthInQuarter.put("12", "4");
        this.normMonthInSeason.put("", "");
        this.normMonthInSeason.put("01", "WI");
        this.normMonthInSeason.put("02", "WI");
        this.normMonthInSeason.put("03", "SP");
        this.normMonthInSeason.put("04", "SP");
        this.normMonthInSeason.put("05", "SP");
        this.normMonthInSeason.put("06", "SU");
        this.normMonthInSeason.put("07", "SU");
        this.normMonthInSeason.put("08", "SU");
        this.normMonthInSeason.put("09", "FA");
        this.normMonthInSeason.put("10", "FA");
        this.normMonthInSeason.put("11", "FA");
        this.normMonthInSeason.put("12", "WI");
        this.normDayInWeek.put("sunday", "1");
        this.normDayInWeek.put("monday", "2");
        this.normDayInWeek.put("tuesday", "3");
        this.normDayInWeek.put("wednesday", "4");
        this.normDayInWeek.put("thursday", "5");
        this.normDayInWeek.put("friday", "6");
        this.normDayInWeek.put("saturday", "7");
        this.normDayInWeek.put("Sunday", "1");
        this.normDayInWeek.put("Monday", "2");
        this.normDayInWeek.put("Tuesday", "3");
        this.normDayInWeek.put("Wednesday", "4");
        this.normDayInWeek.put("Thursday", "5");
        this.normDayInWeek.put("Friday", "6");
        this.normDayInWeek.put("Saturday", "7");
        this.normNumber.put("0", "00");
        this.normNumber.put("00", "00");
        this.normNumber.put("1", "01");
        this.normNumber.put("01", "01");
        this.normNumber.put("2", "02");
        this.normNumber.put("02", "02");
        this.normNumber.put("3", "03");
        this.normNumber.put("03", "03");
        this.normNumber.put("4", "04");
        this.normNumber.put("04", "04");
        this.normNumber.put("5", "05");
        this.normNumber.put("05", "05");
        this.normNumber.put("6", "06");
        this.normNumber.put("06", "06");
        this.normNumber.put("7", "07");
        this.normNumber.put("07", "07");
        this.normNumber.put("8", "08");
        this.normNumber.put("08", "08");
        this.normNumber.put("9", "09");
        this.normNumber.put("09", "09");
        this.normNumber.put("10", "10");
        this.normNumber.put("11", "11");
        this.normNumber.put("12", "12");
        this.normNumber.put("13", "13");
        this.normNumber.put("14", "14");
        this.normNumber.put("15", "15");
        this.normNumber.put("16", "16");
        this.normNumber.put("17", "17");
        this.normNumber.put("18", "18");
        this.normNumber.put("19", "19");
        this.normNumber.put("20", "20");
        this.normNumber.put("21", "21");
        this.normNumber.put("22", "22");
        this.normNumber.put("23", "23");
        this.normNumber.put("24", "24");
        this.normNumber.put("25", "25");
        this.normNumber.put("26", "26");
        this.normNumber.put("27", "27");
        this.normNumber.put("28", "28");
        this.normNumber.put("29", "29");
        this.normNumber.put("30", "30");
        this.normNumber.put("31", "31");
        this.normNumber.put("32", "32");
        this.normNumber.put("33", "33");
        this.normNumber.put("34", "34");
        this.normNumber.put("35", "35");
        this.normNumber.put("36", "36");
        this.normNumber.put("37", "37");
        this.normNumber.put("38", "38");
        this.normNumber.put("39", "39");
        this.normNumber.put("40", "40");
        this.normNumber.put("41", "41");
        this.normNumber.put("42", "42");
        this.normNumber.put("43", "43");
        this.normNumber.put("44", "44");
        this.normNumber.put("45", "45");
        this.normNumber.put("46", "46");
        this.normNumber.put("47", "47");
        this.normNumber.put("48", "48");
        this.normNumber.put("49", "49");
        this.normNumber.put("50", "50");
        this.normNumber.put("51", "51");
        this.normNumber.put("52", "52");
        this.normNumber.put("53", "53");
        this.normNumber.put("54", "54");
        this.normNumber.put("55", "55");
        this.normNumber.put("56", "56");
        this.normNumber.put("57", "57");
        this.normNumber.put("58", "58");
        this.normNumber.put("59", "59");
        this.normNumber.put("60", "60");
        this.normMonthName.put("january", "01");
        this.normMonthName.put("february", "02");
        this.normMonthName.put("march", "03");
        this.normMonthName.put("april", "04");
        this.normMonthName.put("may", "05");
        this.normMonthName.put("june", "06");
        this.normMonthName.put("july", "07");
        this.normMonthName.put("august", "08");
        this.normMonthName.put("september", "09");
        this.normMonthName.put("october", "10");
        this.normMonthName.put("november", "11");
        this.normMonthName.put("december", "12");
    }

    public final RegexHashMap<String> getFromHmAllNormalization(String key) {
        return this.hmAllNormalization.get(key);
    }

    public final String getFromNormNumber(String key) {
        return this.normNumber.get(key);
    }

    public final String getFromNormDayInWeek(String key) {
        return this.normDayInWeek.get(key);
    }

    public final String getFromNormMonthName(String key) {
        return this.normMonthName.get(key);
    }

    public final String getFromNormMonthInSeason(String key) {
        return this.normMonthInSeason.get(key);
    }

    public final String getFromNormMonthInQuarter(String key) {
        return this.normMonthInQuarter.get(key);
    }
}

