/*
 * Decompiled with CFR 0.152.
 */
package de.unihd.dbs.uima.annotator.heideltime.processors;

import de.unihd.dbs.uima.annotator.heideltime.processors.GenericProcessor;
import de.unihd.dbs.uima.types.heideltime.Timex3;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.UimaContext;
import org.apache.uima.jcas.JCas;

public class DecadeProcessor
extends GenericProcessor {
    @Override
    public void initialize(UimaContext aContext) {
    }

    @Override
    public void process(JCas jcas) {
        this.evaluateFunctions(jcas);
    }

    public void evaluateFunctions(JCas jcas) {
        ArrayList<Timex3> linearDates = new ArrayList<Timex3>();
        for (Timex3 timex : jcas.getAnnotationIndex(Timex3.type)) {
            if (!timex.getTimexType().equals("DATE")) continue;
            linearDates.add(timex);
        }
        Pattern cmd_p = Pattern.compile("(\\w\\w\\w\\w)-(\\w\\w)-(\\w\\w)\\s+decadeCalc\\((\\d+)\\)");
        for (int i = 0; i < linearDates.size(); ++i) {
            Timex3 t_i = (Timex3)((Object)linearDates.get(i));
            String value_i = t_i.getTimexValue();
            Matcher cmd_m = cmd_p.matcher(value_i);
            String valueNew = value_i;
            if (cmd_m.matches()) {
                String year = cmd_m.group(1);
                String argument = cmd_m.group(4);
                valueNew = year.substring(0, Math.min(2, year.length())) + argument.substring(0, 1);
            }
            t_i.removeFromIndexes();
            t_i.setTimexValue(valueNew);
            t_i.addToIndexes();
            linearDates.set(i, t_i);
        }
    }
}

