/*
 * Decompiled with CFR 0.152.
 */
package de.unihd.dbs.uima.annotator.heideltime;

import de.unihd.dbs.uima.annotator.heideltime.processors.GenericProcessor;
import de.unihd.dbs.uima.annotator.heideltime.utilities.Logger;
import java.util.EnumMap;
import java.util.LinkedList;
import org.apache.uima.UimaContext;
import org.apache.uima.jcas.JCas;

public class ProcessorManager {
    private EnumMap<Priority, LinkedList<String>> processorNames = new EnumMap(Priority.class);
    private EnumMap<Priority, LinkedList<GenericProcessor>> processors;
    private Class<?> component = this.getClass();
    private boolean initialized = false;

    public ProcessorManager() {
        this.processors = new EnumMap(Priority.class);
        for (Priority prio : Priority.values()) {
            this.processorNames.put(prio, new LinkedList());
            this.processors.put(prio, new LinkedList());
        }
    }

    public void registerProcessor(String processor, Priority prio) {
        this.processorNames.get((Object)prio).add(processor);
    }

    public void registerProcessor(String processor) {
        this.registerProcessor(processor, Priority.POSTPROCESSING);
    }

    public void initializeAllProcessors(UimaContext aContext) {
        for (Priority prio : this.processorNames.keySet()) {
            for (String pn : this.processorNames.get((Object)prio)) {
                try {
                    Class<?> c = Class.forName(pn);
                    GenericProcessor p = (GenericProcessor)c.newInstance();
                    p.initialize(aContext);
                    this.processors.get((Object)prio).add(p);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Logger.printError(this.component, "Unable to initialize registered Processor " + pn + ", got: " + exception.toString());
                    System.exit(-1);
                }
            }
        }
        this.initialized = true;
    }

    public void executeProcessors(JCas jcas, Priority prio) {
        if (!this.initialized) {
            Logger.printError(this.component, "Unable to execute Processors; initialization was not concluded successfully.");
            System.exit(-1);
        }
        LinkedList<GenericProcessor> myList = this.processors.get((Object)prio);
        for (GenericProcessor gp : myList) {
            try {
                gp.process(jcas);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Logger.printError(this.component, "Unable to process registered Processor " + gp.getClass().getName() + ", got: " + exception.toString());
                System.exit(-1);
            }
        }
    }

    public static enum Priority {
        PREPROCESSING,
        POSTPROCESSING,
        ARBITRARY;

    }
}

