/*
 * Decompiled with CFR 0.152.
 */
package de.unihd.dbs.heideltime.standalone.components.impl;

import de.unihd.dbs.heideltime.standalone.components.ResultFormatter;
import de.unihd.dbs.uima.types.heideltime.Timex3;
import de.unihd.dbs.uima.types.heideltime.Timex3Interval;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;

public class TimeMLResultFormatter
implements ResultFormatter {
    @Override
    public String format(JCas jcas) throws Exception {
        String documentText = jcas.getDocumentText();
        String outText = new String();
        FSIterator iterIntervals = jcas.getAnnotationIndex(Timex3Interval.type).iterator();
        TreeMap<Integer, Timex3Interval> intervals = new TreeMap<Integer, Timex3Interval>();
        while (iterIntervals.hasNext()) {
            Timex3Interval t = (Timex3Interval)((Object)iterIntervals.next());
            if (t.getTimexValueLE().equals(t.getTimexValueLB()) && t.getTimexValueEE().equals(t.getTimexValueEB())) continue;
            if (intervals.containsKey(t.getBegin())) {
                Timex3Interval tInt = (Timex3Interval)((Object)intervals.get(t.getBegin()));
                if (t.getEnd() - t.getBegin() <= tInt.getEnd() - tInt.getBegin()) continue;
                intervals.put(t.getBegin(), t);
                continue;
            }
            intervals.put(t.getBegin(), t);
        }
        FSIterator iterTimex = jcas.getAnnotationIndex(Timex3.type).iterator();
        TreeMap<Integer, Timex3> forwardTimexes = new TreeMap<Integer, Timex3>();
        TreeMap<Integer, Timex3> backwardTimexes = new TreeMap<Integer, Timex3>();
        while (iterTimex.hasNext()) {
            Timex3 t = (Timex3)((Object)iterTimex.next());
            forwardTimexes.put(t.getBegin(), t);
            backwardTimexes.put(t.getEnd(), t);
        }
        HashSet<Timex3> timexesToSkip = new HashSet<Timex3>();
        Timex3 prevT = null;
        Timex3 thisT = null;
        for (Integer begin : forwardTimexes.navigableKeySet()) {
            thisT = (Timex3)((Object)forwardTimexes.get(begin));
            if (prevT != null && prevT.getEnd() > thisT.getBegin()) {
                Timex3 removedT = null;
                if (prevT.getTimexValue().length() > thisT.getTimexValue().length()) {
                    timexesToSkip.add(thisT);
                    removedT = thisT;
                } else {
                    timexesToSkip.add(prevT);
                    removedT = prevT;
                    prevT = thisT;
                }
                Logger l = Logger.getLogger("TimeMLResultFormatter");
                l.log(Level.WARNING, "Two overlapping Timexes have been discovered:" + System.getProperty("line.separator") + "Timex A: " + prevT.getCoveredText() + " [\"" + prevT.getTimexValue() + "\" / " + prevT.getBegin() + ":" + prevT.getEnd() + "]" + System.getProperty("line.separator") + "Timex B: " + removedT.getCoveredText() + " [\"" + removedT.getTimexValue() + "\" / " + removedT.getBegin() + ":" + removedT.getEnd() + "] [removed]" + System.getProperty("line.separator") + "The writer chose, for granularity: " + prevT.getCoveredText() + System.getProperty("line.separator") + "This usually happens with an incomplete ruleset. Please consider adding a new rule that covers the entire expression.");
                continue;
            }
            prevT = thisT;
        }
        Timex3Interval interval = null;
        Timex3 timex = null;
        Integer docOffset = 0;
        while (docOffset <= documentText.length()) {
            if (timex != null && timex.getEnd() == docOffset.intValue()) {
                outText = outText + "</TIMEX3>";
                timex = null;
            }
            if (interval != null && interval.getEnd() == docOffset.intValue()) {
                outText = outText + "</TIMEX3INTERVAL>";
                interval = null;
            }
            if (interval == null && intervals.containsKey(docOffset)) {
                interval = (Timex3Interval)((Object)intervals.get(docOffset));
            }
            if (timex == null && forwardTimexes.containsKey(docOffset) && !timexesToSkip.contains(forwardTimexes.get(docOffset))) {
                timex = (Timex3)((Object)forwardTimexes.get(docOffset));
            }
            if (interval != null && interval.getBegin() == docOffset.intValue()) {
                String intervalTag = "<TIMEX3INTERVAL";
                if (!interval.getTimexValueEB().equals("")) {
                    intervalTag = intervalTag + " earliestBegin=\"" + interval.getTimexValueEB() + "\"";
                }
                if (!interval.getTimexValueLB().equals("")) {
                    intervalTag = intervalTag + " latestBegin=\"" + interval.getTimexValueLB() + "\"";
                }
                if (!interval.getTimexValueEE().equals("")) {
                    intervalTag = intervalTag + " earliestEnd=\"" + interval.getTimexValueEE() + "\"";
                }
                if (!interval.getTimexValueLE().equals("")) {
                    intervalTag = intervalTag + " latestEnd=\"" + interval.getTimexValueLE() + "\"";
                }
                intervalTag = intervalTag + ">";
                outText = outText + intervalTag;
            }
            if (timex != null && timex.getBegin() == docOffset.intValue()) {
                String timexTag = "<TIMEX3";
                if (!timex.getTimexId().equals("")) {
                    timexTag = timexTag + " tid=\"" + timex.getTimexId() + "\"";
                }
                if (!timex.getTimexType().equals("")) {
                    timexTag = timexTag + " type=\"" + timex.getTimexType() + "\"";
                }
                if (!timex.getTimexValue().equals("")) {
                    timexTag = timexTag + " value=\"" + timex.getTimexValue() + "\"";
                }
                if (!timex.getTimexQuant().equals("")) {
                    timexTag = timexTag + " quant=\"" + timex.getTimexQuant() + "\"";
                }
                if (!timex.getTimexFreq().equals("")) {
                    timexTag = timexTag + " freq=\"" + timex.getTimexFreq() + "\"";
                }
                if (!timex.getTimexMod().equals("")) {
                    timexTag = timexTag + " mod=\"" + timex.getTimexMod() + "\"";
                }
                timexTag = timexTag + ">";
                outText = outText + timexTag;
            }
            if (docOffset + 1 <= documentText.length()) {
                outText = outText + documentText.substring(docOffset, docOffset + 1);
            }
            Integer n = docOffset;
            Integer n2 = docOffset = Integer.valueOf(docOffset + 1);
        }
        outText = "<?xml version=\"1.0\"?>\n<!DOCTYPE TimeML SYSTEM \"TimeML.dtd\">\n<TimeML>\n" + outText + "\n</TimeML>\n";
        return outText;
    }
}

