/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.verb;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerbModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(VerbModel.class);
    private static VerbModel ourInstance = null;
    Set<String> transitiveVerbs;

    public static VerbModel getInstance() {
        return VerbModel.getInstance(null);
    }

    public static VerbModel getInstance(String fileName) {
        HashSet<String> transitiveVerbs = new HashSet<String>();
        if (ourInstance == null) {
            try {
                InputStream configStream = fileName == null ? VerbModel.class.getResourceAsStream("/transitivi.txt") : new FileInputStream(fileName);
                if (configStream != null) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(configStream));
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                        transitiveVerbs.add(line);
                    }
                    reader.close();
                }
                ourInstance = new VerbModel(transitiveVerbs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            LOGGER.info("Verb model already loaded");
        }
        return ourInstance;
    }

    private VerbModel(Set<String> transitiveVerbs) {
        this.transitiveVerbs = transitiveVerbs;
    }

    public Set<String> getTransitiveVerbs() {
        return this.transitiveVerbs;
    }
}

